<?php
require_once 'includes/db.php';

$config_id = 74;

$stmt = $pdo->prepare("SELECT heat_number, configuration FROM result_configurations WHERE id = ?");
$stmt->execute([$config_id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

echo "Config ID: $config_id\n\n";
echo "heat_number column value:\n";
echo "  Type: " . gettype($row['heat_number']) . "\n";
echo "  Value: " . var_export($row['heat_number'], true) . "\n";
echo "  Length: " . strlen($row['heat_number']) . "\n";
echo "  Raw bytes: " . bin2hex($row['heat_number']) . "\n\n";

echo "JSON decode test:\n";
$decoded = json_decode($row['heat_number'], true);
echo "  Result: " . var_export($decoded, true) . "\n";
echo "  Error: " . json_last_error_msg() . "\n\n";

echo "is_numeric test: " . (is_numeric($row['heat_number']) ? 'true' : 'false') . "\n\n";

echo "Configuration column:\n";
$config = json_decode($row['configuration'], true);
echo "  heat_number in config: " . var_export($config['heat_number'] ?? null, true) . "\n";
?>
