<?php
// Test participant color functionality
include '../includes/participant_colors.php';

// Test data
$test_participants = [
    'participant1' => [
        'bib' => '101',
        'first_name' => 'John',
        'last_name' => 'Doe'
    ],
    'participant2' => [
        'bib' => '102', 
        'first_name' => 'Jane',
        'last_name' => 'Smith'
    ],
    'participant3' => [
        'bib' => '103',
        'first_name' => 'Alice',
        'last_name' => 'Johnson'
    ]
];

echo "Testing participant color generation...\n\n";

// Generate colors
$colors = collectParticipantColors($test_participants, ['mode' => 'light', 'saturation' => 0.65]);

// Display results
foreach ($colors as $badge_class => $color_data) {
    echo "Badge Class: $badge_class\n";
    echo "Initials: " . $color_data['initials'] . "\n";
    echo "Background: " . $color_data['bg'] . "\n";
    echo "Text: " . $color_data['text'] . "\n";
    echo "Light: " . $color_data['light'] . "\n";
    echo "Dark: " . $color_data['dark'] . "\n";
    echo "Accent: " . $color_data['accent'] . "\n";
    echo "---\n";
}

// Generate CSS
$css = generateParticipantCSS($colors);
echo "\nGenerated CSS:\n";
echo $css;

echo "\nTest completed successfully!\n";
?>
