<?php
include 'includes/db.php';

echo "<h1>Check Styling Data in Database</h1>";

// Check what events exist
$stmt = $pdo->query("SELECT id, name FROM events ORDER BY id");
$events = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>Available Events:</h2>";
echo "<ul>";
foreach ($events as $event) {
    echo "<li>Event ID {$event['id']}: {$event['name']}</li>";
}
echo "</ul>";

// Check if there's any styling data
$stmt = $pdo->query("SELECT * FROM result_styling");
$styling_rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>Styling Data in Database:</h2>";
if (empty($styling_rows)) {
    echo "<p style='color: red; font-weight: bold;'>NO STYLING DATA FOUND IN DATABASE!</p>";
    echo "<p>You need to configure styling first. Go to: <a href='/v2/admin/results_styling.php?event_id=3'>Configure Styling</a></p>";
} else {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Event ID</th><th>Config ID</th><th>Has Logo</th><th>Header Content</th><th>Created</th></tr>";
    foreach ($styling_rows as $row) {
        $styling = json_decode($row['styling_data'], true);
        echo "<tr>";
        echo "<td>{$row['id']}</td>";
        echo "<td>{$row['event_id']}</td>";
        echo "<td>" . ($row['config_id'] ?? 'NULL') . "</td>";
        echo "<td>" . (!empty($styling['logo_url']) ? 'YES' : 'NO') . "</td>";
        echo "<td>" . htmlspecialchars(substr($styling['header_content'] ?? '', 0, 50)) . "</td>";
        echo "<td>{$row['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h3>Full Styling Data:</h3>";
    foreach ($styling_rows as $row) {
        echo "<h4>Event ID: {$row['event_id']}</h4>";
        $styling = json_decode($row['styling_data'], true);
        echo "<pre>" . print_r($styling, true) . "</pre>";
    }
}
