<?php
// Add scoring layout configuration columns to database
require_once 'includes/db.php';

echo "<h2>Adding Scoring Layout Configuration Database Columns</h2>";

try {
    // Add scoring_layout_config column to events table
    echo "<h3>Adding column to events table...</h3>";
    
    try {
        $pdo->query("ALTER TABLE events ADD COLUMN scoring_layout_config JSON NULL");
        echo "<span style='color:green'>✓ Added scoring_layout_config column to events table</span><br>";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "<span style='color:orange'>ⓘ scoring_layout_config column already exists in events table</span><br>";
        } else {
            throw $e;
        }
    }
    
    // Add scoring_layout_config column to event_heat_settings table
    echo "<h3>Adding column to event_heat_settings table...</h3>";
    
    try {
        $pdo->query("ALTER TABLE event_heat_settings ADD COLUMN scoring_layout_config JSON NULL");
        echo "<span style='color:green'>✓ Added scoring_layout_config column to event_heat_settings table</span><br>";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "<span style='color:orange'>ⓘ scoring_layout_config column already exists in event_heat_settings table</span><br>";
        } else {
            throw $e;
        }
    }
    
    echo "<h3>Database Setup Complete!</h3>";
    echo "<p style='color:green;'>The scoring layout configuration columns have been successfully added to the database.</p>";
    echo "<p><a href='test_scoring_layout_db.php'>Run Database Integration Test</a></p>";
    
} catch (Exception $e) {
    echo "<span style='color:red;'>Error: " . $e->getMessage() . "</span>";
}
?>