<?php
/**
 * Demo Panels Access Helper
 * This file helps redirect users to the proper demo panels URL
 */

// Get the current server and path
$serverName = $_SERVER['SERVER_NAME'];
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$baseUrl = $protocol . '://' . $serverName;

// Construct the demo panels URL
$demoPanelsUrl = $baseUrl . '/v2/judge/demo_panels/';

// If this is an AJAX request or API call, return JSON
if (isset($_GET['api']) || isset($_POST['api'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'demo_panels_url' => $demoPanelsUrl,
        'server' => $serverName,
        'protocol' => $protocol,
        'message' => 'Demo panels are available at the URL provided'
    ]);
    exit;
}

// Otherwise redirect to the demo panels
header('Location: ' . $demoPanelsUrl);
exit;
?>
