<?php
include 'db.php';

try {
    // Add created_by column to token_transactions table
    $pdo->exec('ALTER TABLE token_transactions ADD COLUMN created_by int(11) DEFAULT NULL');
    echo "✓ Added created_by column to token_transactions table\n";
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "✓ created_by column already exists in token_transactions table\n";
    } else {
        echo "Error: " . $e->getMessage() . "\n";
    }
}

// Verify the column was added
try {
    $stmt = $pdo->query('DESCRIBE token_transactions');
    echo "\ntoken_transactions table structure:\n";
    while ($row = $stmt->fetch()) {
        echo "  " . $row['Field'] . " - " . $row['Type'] . "\n";
    }
} catch (Exception $e) {
    echo "Error checking table: " . $e->getMessage() . "\n";
}
?>
