<?php
require_once 'includes/db.php';
require_once 'includes/ScoringLayoutConfig.php';

echo "<h2>Debug Scoring Layout Configuration</h2>";

$event_id = 3;
$heat_number = 1;

echo "<h3>Step 1: Check Database Configuration</h3>";
$stmt = $pdo->prepare("SELECT * FROM scoring_layout_configs WHERE event_id = ?");
$stmt->execute([$event_id]);
$config = $stmt->fetch();

if ($config) {
    echo "<p><strong>✅ Configuration found in database</strong></p>";
    echo "<pre>" . htmlspecialchars($config['configuration']) . "</pre>";
    
    $configData = json_decode($config['configuration'], true);
    echo "<h4>Parsed Configuration:</h4>";
    echo "<pre>" . print_r($configData, true) . "</pre>";
} else {
    echo "<p style='color: red;'><strong>❌ No configuration found for Event $event_id</strong></p>";
}

echo "<h3>Step 2: Test ScoringLayoutConfig Class</h3>";
try {
    $effectiveConfig = ScoringLayoutConfig::getEffectiveConfig($pdo, $event_id, $heat_number);
    
    if ($effectiveConfig) {
        echo "<p><strong>✅ Effective configuration loaded</strong></p>";
        echo "<pre>" . print_r($effectiveConfig, true) . "</pre>";
        
        echo "<h3>Step 3: Generated JavaScript</h3>";
        $script = ScoringLayoutConfig::generateApplyScript($effectiveConfig);
        echo "<p><strong>JavaScript that should be applied:</strong></p>";
        echo "<textarea style='width:100%; height:300px;'>" . htmlspecialchars($script) . "</textarea>";
        
        echo "<h3>Step 4: Component Selectors Test</h3>";
        $components = ScoringLayoutConfig::getAvailableComponents();
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>Component</th><th>Enabled</th><th>Selector</th><th>Fallback</th></tr>";
        foreach ($components as $key => $component) {
            $enabled = $effectiveConfig['cards'][$key]['enabled'] ?? true;
            $status = $enabled ? '<span style="color: green;">✅ SHOW</span>' : '<span style="color: red;">❌ HIDE</span>';
            echo "<tr>";
            echo "<td>{$component['title']}</td>";
            echo "<td>$status</td>";
            echo "<td>{$component['selector']}</td>";
            echo "<td>{$component['fallback_selector']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
    } else {
        echo "<p style='color: red;'><strong>❌ No effective configuration returned</strong></p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'><strong>❌ Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
}

echo "<h3>Step 5: Live Judge Panel Test</h3>";
echo "<p><a href='judge/score.php?event_id=3&heat_number=1&debug=1' target='_blank'>Open Judge Panel with Debug</a></p>";
echo "<p><em>Check the browser's Developer Tools Console for any JavaScript errors</em></p>";

echo "<h3>Step 6: Manual JavaScript Test</h3>";
echo "<p>Copy this JavaScript and run it in the browser console on the judge panel:</p>";
if (isset($script)) {
    echo "<textarea style='width:100%; height:150px;'>" . htmlspecialchars($script) . "</textarea>";
}
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { margin-top: 10px; }
th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
pre { background: #f5f5f5; padding: 10px; border-radius: 5px; overflow-x: auto; }
textarea { font-family: monospace; }
</style>