<?php
include 'includes/db.php';

$event_id = 6; // SNOWFEST Festival

$event_stmt = $pdo->prepare("
    SELECT e.*, 
           sf.name as format_name, sf.mode as format_mode,
           fsd.icon_path as sport_icon_path, fsd.short_name as sport_short_name
    FROM events e
    LEFT JOIN scoring_formats sf ON e.scoring_format = sf.format_id
    LEFT JOIN figure_sports fs ON LOWER(e.sport_discipline) = LOWER(fs.sport_name)
    LEFT JOIN figure_sport_details fsd ON fs.id = fsd.sport_id
    WHERE e.id = ?
");
$event_stmt->execute([$event_id]);
$event = $event_stmt->fetch(PDO::FETCH_ASSOC);

echo "Event scoring_format value: " . ($event['scoring_format'] ?? 'NULL') . "\n";
echo "Format name from JOIN: " . ($event['format_name'] ?? 'NULL') . "\n";
echo "Format mode from JOIN: " . ($event['format_mode'] ?? 'NULL') . "\n";
echo "\n";

if (!empty($event['scoring_format'])) {
    echo "Trying to fetch format details...\n";
    $format_stmt = $pdo->prepare("
        SELECT sf.*, 
               sfj.min_judges, sfj.max_judges, sfj.scale_min, sfj.scale_max, 
               sfj.scale_type, sfj.scale_custom, sfj.precision_decimal, sfj.drop_rule
        FROM scoring_formats sf
        LEFT JOIN scoring_format_judges sfj ON sf.format_id = sfj.format_id
        WHERE sf.format_id = ?
    ");
    $format_stmt->execute([$event['scoring_format']]);
    $formatSettings = $format_stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($formatSettings) {
        echo "✓ Format found!\n";
        echo "Format name: " . $formatSettings['name'] . "\n";
        echo "Min judges: " . $formatSettings['min_judges'] . "\n";
    } else {
        echo "✗ Format NOT found\n";
    }
} else {
    echo "Event has no scoring_format set!\n";
}
