<?php
require_once 'includes/db.php';

echo "<h2>Create Dramatic Test Configuration for Event 3</h2>";

// Create a very obvious configuration that hides most components
$testConfig = [
    'cards' => [
        'criteriaInputGrid' => ['enabled' => false], // HIDE criteria input
        'finalCalculatedScore' => ['enabled' => true],  // SHOW final score 
        'figuresCard' => ['enabled' => false], // HIDE figures card
        'latestScores' => ['enabled' => false], // HIDE latest scores table
        'otherHeatScores' => ['enabled' => false], // HIDE other scores
        'diversityValidation' => ['enabled' => false], // HIDE diversity validation
        'figureHistory' => ['enabled' => false], // HIDE figure history
        'formatInfo' => ['enabled' => false] // HIDE format info
    ],
    'layout' => [
        'compactMode' => false,
        'hideEmptyCards' => true
    ]
];

try {
    // Delete existing configuration and insert new one
    $deleteStmt = $pdo->prepare("DELETE FROM scoring_layout_configs WHERE event_id = ?");
    $deleteStmt->execute([3]);
    
    $stmt = $pdo->prepare("INSERT INTO scoring_layout_configs (event_id, heat_number, configuration, created_at, updated_at) VALUES (?, ?, ?, NOW(), NOW())");
    
    $configJson = json_encode($testConfig);
    $stmt->execute([3, null, $configJson]); // null heat_number means applies to all heats
    
    echo "<p><strong>✅ DRAMATIC Test configuration created for Event 3</strong></p>";
    echo "<p><strong style='color:red;'>This should HIDE almost everything except Final Score Display!</strong></p>";
    
    echo "<h3>What should be HIDDEN:</h3>";
    echo "<ul>";
    echo "<li>❌ Criteria Input Grid</li>";
    echo "<li>❌ Figures Card</li>";
    echo "<li>❌ Latest Scores Table</li>";
    echo "<li>❌ Other Heat Scores</li>";
    echo "<li>❌ Diversity Validation</li>";
    echo "<li>❌ Figure History</li>";
    echo "<li>❌ Format Information</li>";
    echo "</ul>";
    
    echo "<h3>What should be SHOWN:</h3>";
    echo "<ul>";
    echo "<li>✅ Final Score Display</li>";
    echo "<li>✅ Participant Selection (always shown)</li>";
    echo "<li>✅ Submit Button (always shown)</li>";
    echo "</ul>";
    
    echo "<h3>Test Now:</h3>";
    echo "<p><a href='judge/score.php?event_id=3&heat_number=1' target='_blank' style='font-size:18px; background:yellow; padding:10px; text-decoration:none; color:black;'><strong>👆 CLICK HERE TO TEST EVENT 3 JUDGE PANEL</strong></a></p>";
    
    echo "<h3>Configuration JSON:</h3>";
    echo "<pre>" . htmlspecialchars($configJson) . "</pre>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>Error creating configuration: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>