<?php
include 'includes/db.php';

echo "Checking participant photos in database...\n\n";

// Check if photo column exists
$stmt = $pdo->query("SHOW COLUMNS FROM participants LIKE 'photo'");
if ($stmt->rowCount() > 0) {
    echo "✓ Photo column exists in participants table\n";
    
    // Check participants with photos
    $stmt = $pdo->query("SELECT id, first_name, last_name, photo FROM participants WHERE photo IS NOT NULL AND photo != '' LIMIT 10");
    $participants = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Participants with photos:\n";
    foreach ($participants as $p) {
        echo "- {$p['first_name']} {$p['last_name']}: {$p['photo']}\n";
    }
    
    $count_stmt = $pdo->query("SELECT COUNT(*) FROM participants WHERE photo IS NOT NULL AND photo != ''");
    $count = $count_stmt->fetchColumn();
    echo "\nTotal participants with photos: $count\n";
    
} else {
    echo "✗ Photo column does not exist in participants table\n";
}

// Check event participants for event 3
echo "\nChecking event 3 participants...\n";
$stmt = $pdo->prepare("
    SELECT ep.bib_number, p.first_name, p.last_name, p.photo
    FROM event_participants ep 
    JOIN participants p ON ep.participant_id = p.id 
    WHERE ep.event_id = 3 
    LIMIT 5
");
$stmt->execute();
$event_participants = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($event_participants as $ep) {
    echo "BIB {$ep['bib_number']}: {$ep['first_name']} {$ep['last_name']} - Photo: " . ($ep['photo'] ?: 'None') . "\n";
}
?>
