<?php
include 'includes/db.php';

$format_id = 'freeski_slopestyle_sections_oi_copy_1762579299';

echo "=== Checking Format Configuration ===\n\n";

// Check main format
$stmt = $pdo->prepare('SELECT * FROM scoring_formats WHERE format_id = ?');
$stmt->execute([$format_id]);
$format = $stmt->fetch(PDO::FETCH_ASSOC);
echo "1. Main Format:\n";
print_r($format);

// Check judge config
$stmt = $pdo->prepare('SELECT * FROM scoring_format_judges WHERE format_id = ?');
$stmt->execute([$format_id]);
$judges = $stmt->fetch(PDO::FETCH_ASSOC);
echo "\n2. Judge Configuration:\n";
print_r($judges ?: "NOT FOUND\n");

// Check mode config
$stmt = $pdo->prepare('SELECT * FROM scoring_format_mode_config WHERE format_id = ?');
$stmt->execute([$format_id]);
$mode_config = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "\n3. Mode Configuration (" . count($mode_config) . " entries):\n";
print_r($mode_config);

// Check rounds
$stmt = $pdo->prepare('SELECT * FROM scoring_format_rounds WHERE format_id = ?');
$stmt->execute([$format_id]);
$rounds = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "\n4. Rounds (" . count($rounds) . " entries):\n";
print_r($rounds);

// Check criteria
$stmt = $pdo->prepare('SELECT * FROM scoring_format_criteria WHERE format_id = ?');
$stmt->execute([$format_id]);
$criteria = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "\n5. Criteria (" . count($criteria) . " entries):\n";
print_r($criteria);
