<?php
include 'includes/db.php';

echo "=== Checking Configuration 84 ===\n\n";

// Check config 84
$stmt = $pdo->prepare('SELECT id, name, event_id, view_type, heat_number, status, display_order FROM result_configurations WHERE id = 84');
$stmt->execute();
$config = $stmt->fetch(PDO::FETCH_ASSOC);

if ($config) {
    echo "Config 84 found:\n";
    foreach ($config as $key => $value) {
        echo "  $key: " . ($value ?? 'NULL') . "\n";
    }
} else {
    echo "Config 84 NOT FOUND!\n";
    exit(1);
}

echo "\n=== All Summary Tables for Event 6 ===\n\n";

$stmt = $pdo->prepare('SELECT id, name, heat_number, status, display_order FROM result_configurations WHERE event_id = 6 AND view_type = "summary_table" ORDER BY heat_number, display_order');
$stmt->execute();
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($configs as $cfg) {
    printf("ID: %3d | Heat: %15s | Status: %8s | Order: %2d | Name: %s\n",
        $cfg['id'],
        $cfg['heat_number'] ?? 'NULL',
        $cfg['status'],
        $cfg['display_order'],
        $cfg['name']
    );
}

echo "\n=== Configurations with heat_number = NULL ===\n\n";

$stmt = $pdo->prepare('SELECT id, name, status FROM result_configurations WHERE event_id = 6 AND view_type = "summary_table" AND heat_number IS NULL');
$stmt->execute();
$nullHeats = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (count($nullHeats) > 0) {
    foreach ($nullHeats as $cfg) {
        echo "  ID: {$cfg['id']} | Status: {$cfg['status']} | Name: {$cfg['name']}\n";
    }
} else {
    echo "  No configurations with NULL heat_number found.\n";
}
