<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>Testing Summary Table Manager Setup</h3>";

// Test includes
try {
    include '../includes/auth.php';
    echo "✅ Auth included<br>";
} catch (Exception $e) {
    echo "❌ Auth error: " . $e->getMessage() . "<br>";
}

try {
    include '../includes/db.php';
    echo "✅ DB included<br>";
} catch (Exception $e) {
    echo "❌ DB error: " . $e->getMessage() . "<br>";
}

// Test database connection
if (isset($pdo)) {
    echo "✅ PDO connection exists<br>";
    
    // Test queries
    try {
        $events = $pdo->query("SELECT id, name FROM events ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
        echo "✅ Events query: " . count($events) . " events found<br>";
        
        if (count($events) > 0) {
            $test_event_id = $events[0]['id'];
            echo "<br><strong>Testing with Event ID: $test_event_id</strong><br>";
            
            // Test heats
            $stmt = $pdo->prepare("SELECT heat_number, heat_name FROM event_heat_settings WHERE event_id = ? ORDER BY heat_number ASC");
            $stmt->execute([$test_event_id]);
            $heats = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "✅ Heats query: " . count($heats) . " heats found<br>";
            
            // Test categories
            $stmt = $pdo->prepare("
                SELECT id, category_name, is_main_category, use_for_ranking 
                FROM event_categories 
                WHERE event_id = ? AND (is_main_category = 1 OR use_for_ranking = 1)
                ORDER BY is_main_category DESC, category_name
            ");
            $stmt->execute([$test_event_id]);
            $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "✅ Categories query: " . count($categories) . " categories found<br>";
            
            // Test configurations
            $stmt = $pdo->prepare("
                SELECT id, name, view_type, heat_number, category, status, display_order, created_at, configuration_json
                FROM result_configurations 
                WHERE event_id = ? AND view_type = 'summary_table'
                ORDER BY display_order ASC, name ASC
            ");
            $stmt->execute([$test_event_id]);
            $configs = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "✅ Configurations query: " . count($configs) . " configs found<br>";
        }
        
    } catch (Exception $e) {
        echo "❌ Query error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ No PDO connection<br>";
}

echo "<br><strong>Session Info:</strong><br>";
echo "Logged in: " . (isset($_SESSION['user_id']) ? 'Yes (User ID: ' . $_SESSION['user_id'] . ')' : 'No') . "<br>";

echo "<br><a href='summary_table_manager.php?event_id=6'>Go to Summary Table Manager (Event 6)</a>";
?>
