<?php
require_once '../includes/config.php';
require_once 'publish_generators.php';

$event_id = 3; // Event 3

echo "Testing scores data...\n";

try {
    $scores_data = getScoresData($event_id, $pdo);
    
    echo "Scores data structure:\n";
    if (isset($scores_data['scores']) && !empty($scores_data['scores'])) {
        echo "Found " . count($scores_data['scores']) . " scores\n";
        
        // Show first few scores
        foreach (array_slice($scores_data['scores'], 0, 3) as $i => $score) {
            echo "\nScore $i:\n";
            echo "  first_name: " . ($score['first_name'] ?? 'NULL') . "\n";
            echo "  last_name: " . ($score['last_name'] ?? 'NULL') . "\n";
            echo "  bib_number: " . ($score['bib_number'] ?? 'NULL') . "\n";
            echo "  score_value: " . ($score['score_value'] ?? 'NULL') . "\n";
            echo "  category: " . ($score['category'] ?? 'NULL') . "\n";
            echo "  heat_number: " . ($score['heat_number'] ?? 'NULL') . "\n";
        }
    } else {
        echo "No scores found\n";
    }
    
    // Also check raw database
    echo "\n--- Raw database check ---\n";
    $stmt = $pdo->prepare("
        SELECT 
            s.score_value, 
            r.run_number,
            p.first_name, 
            p.last_name, 
            ep.bib_number,
            ep.heat_number
        FROM scores s
        JOIN runs r ON s.run_id = r.id
        JOIN event_participants ep ON r.event_participant_id = ep.id
        JOIN participants p ON ep.participant_id = p.id
        WHERE ep.event_id = ?
        ORDER BY s.id DESC
        LIMIT 5
    ");
    $stmt->execute([$event_id]);
    $raw_scores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Raw scores count: " . count($raw_scores) . "\n";
    foreach ($raw_scores as $i => $score) {
        echo "Raw $i: {$score['first_name']} {$score['last_name']} - Bib {$score['bib_number']} - Score {$score['score_value']}\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
