<?php
// Test publish functionality in isolation
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../includes/db.php';
require_once 'publish_generators.php';

// Test if we can run the publish function without errors
echo "Testing publish functionality...\n";

try {
    // Test with a simple configuration
    $test_server = [
        'id' => 999,
        'name' => 'Test Server',
        'host' => 'test.example.com',
        'port' => 21,
        'username' => 'test',
        'password' => 'test',
        'remote_path' => '/',
        'event_id' => 5,
        'data_types' => json_encode(['html_dashboard'])
    ];
    
    echo "Test server config:\n";
    print_r($test_server);
    
    // Create a temp directory for testing
    $temp_dir = sys_get_temp_dir() . '/publish_test_' . time();
    mkdir($temp_dir, 0755, true);
    echo "Created temp directory: $temp_dir\n";
    
    // Test just the HTML dashboard generation
    echo "Testing generateStaticHTMLDashboard...\n";
    ob_start();
    $files = generateStaticHTMLDashboard(5, $temp_dir, $pdo);
    $output = ob_get_clean();
    
    if (!empty($output)) {
        echo "WARNING: Function produced output:\n";
        echo "OUTPUT: " . $output . "\n";
    }
    
    echo "Generated " . count($files) . " files successfully\n";
    
    // List generated files
    foreach ($files as $file) {
        echo "- " . $file['remote'] . " (" . filesize($file['local']) . " bytes)\n";
    }
    
    echo "Test completed successfully!\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

// Clean up
if (isset($temp_dir) && is_dir($temp_dir)) {
    echo "Cleaning up temp directory...\n";
    exec("rmdir /s /q " . escapeshellarg($temp_dir));
}
?>
