<?php
require_once '../includes/db.php';
require_once 'publish_generators.php';

echo "<h2>JSON File Generation Test</h2>";

$event_id = 1; // Try with event ID 1 first
$temp_dir = sys_get_temp_dir() . '/stylescore_test_' . time();

// First check what events exist
echo "<h3>Available Events</h3>";
try {
    $events_stmt = $pdo->query("SELECT id, name, status FROM events ORDER BY id ASC LIMIT 10");
    $events = $events_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($events)) {
        echo "<p style='color: red;'>No events found in database!</p>";
    } else {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Name</th><th>Status</th></tr>";
        foreach ($events as $event) {
            echo "<tr><td>{$event['id']}</td><td>{$event['name']}</td><td>{$event['status']}</td></tr>";
        }
        echo "</table>";
        
        // Use the first event
        $event_id = $events[0]['id'];
        echo "<p>Using Event ID: $event_id</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error checking events: " . htmlspecialchars($e->getMessage()) . "</p>";
}

if (!is_dir($temp_dir)) {
    mkdir($temp_dir, 0777, true);
}

echo "<p>Testing Event ID: $event_id</p>";
echo "<p>Temp Directory: $temp_dir</p>";

try {
    echo "<h3>Generating HTML Dashboard Files</h3>";
    $files = generateHTMLDashboard($event_id, $temp_dir, $pdo);
    
    echo "<p>Generated " . count($files) . " files:</p>";
    echo "<table border='1'>";
    echo "<tr><th>Remote Name</th><th>Local Path</th><th>Exists</th><th>Size</th><th>Content Preview</th></tr>";
    
    foreach ($files as $file) {
        $exists = file_exists($file['local']);
        $size = $exists ? filesize($file['local']) : 0;
        
        echo "<tr>";
        echo "<td>" . htmlspecialchars($file['remote']) . "</td>";
        echo "<td>" . htmlspecialchars($file['local']) . "</td>";
        echo "<td>" . ($exists ? "✓" : "✗") . "</td>";
        echo "<td>" . $size . " bytes</td>";
        
        if ($exists && $size > 0) {
            $content = file_get_contents($file['local']);
            if (strpos($file['remote'], '.json') !== false) {
                // For JSON files, show formatted content
                $json_data = json_decode($content, true);
                if ($json_data !== null) {
                    echo "<td><pre>" . htmlspecialchars(substr(json_encode($json_data, JSON_PRETTY_PRINT), 0, 500)) . "...</pre></td>";
                } else {
                    echo "<td>Invalid JSON</td>";
                }
            } else {
                // For other files, show first 200 chars
                echo "<td><pre>" . htmlspecialchars(substr($content, 0, 200)) . "...</pre></td>";
            }
        } else {
            echo "<td>No content</td>";
        }
        
        echo "</tr>";
    }
    echo "</table>";
    
    // Test specific JSON files
    echo "<h3>JSON File Content Details</h3>";
    
    $json_files = ['data_overview.json', 'data_heats.json', 'data_scores.json', 'data_all.json'];
    
    foreach ($json_files as $json_file) {
        echo "<h4>$json_file</h4>";
        $local_path = $temp_dir . '/' . $json_file;
        
        if (file_exists($local_path)) {
            $content = file_get_contents($local_path);
            $json_data = json_decode($content, true);
            
            if ($json_data !== null) {
                echo "<p>✓ Valid JSON (" . strlen($content) . " bytes)</p>";
                echo "<details><summary>View Content</summary>";
                echo "<pre>" . htmlspecialchars(json_encode($json_data, JSON_PRETTY_PRINT)) . "</pre>";
                echo "</details>";
            } else {
                echo "<p>✗ Invalid JSON</p>";
                echo "<pre>" . htmlspecialchars($content) . "</pre>";
            }
        } else {
            echo "<p>✗ File not found</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

// Clean up
if (is_dir($temp_dir)) {
    $files = glob($temp_dir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    rmdir($temp_dir);
    echo "<p>Cleaned up temp directory</p>";
}
?>
