<?php
require_once '../includes/config.php';
require_once 'publish_generators.php';

// Quick test to see the heats data structure
$event_id = 3; // Use event 3 which we know has data

echo "Testing heats data structure...\n";

try {
    $heats_data = getHeatsData($event_id, $pdo);
    echo "Heats data structure:\n";
    echo json_encode($heats_data, JSON_PRETTY_PRINT) . "\n";
    
    echo "\nType of heats_data['heats']: " . gettype($heats_data['heats']) . "\n";
    echo "Is array: " . (is_array($heats_data['heats']) ? 'yes' : 'no') . "\n";
    echo "Count: " . count($heats_data['heats']) . "\n";
    
    if (is_array($heats_data['heats']) && !empty($heats_data['heats'])) {
        echo "First key: " . array_keys($heats_data['heats'])[0] . "\n";
        echo "Keys: " . implode(', ', array_keys($heats_data['heats'])) . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
