<?php
// Test the heat_cards_api.php output
$event_id = 6;
$url = "http://localhost/v2/admin/heat_cards_api.php?event_id=$event_id";

$context = stream_context_create([
    'http' => [
        'method' => 'GET',
        'header' => "Cookie: " . $_SERVER['HTTP_COOKIE'] . "\r\n"
    ]
]);

$response = file_get_contents($url, false, $context);
$data = json_decode($response, true);

if ($data['success']) {
    echo "SUCCESS! Generated {$data['heat_count']} heat cards\n";
    echo "Timestamp: {$data['timestamp']}\n\n";
    
    // Check if HTML contains judge information
    if (strpos($data['data'], 'Judges') !== false) {
        echo "✓ Judge section found in HTML\n";
        
        // Extract judge sections
        preg_match_all('/<small class="fw-bold text-primary">.*?Judges \((\d+)\).*?<\/small>/s', $data['data'], $matches);
        if (!empty($matches[1])) {
            echo "Judge counts per heat: " . implode(', ', $matches[1]) . "\n";
        }
    } else {
        echo "✗ No judge section found\n";
    }
    
    // Save HTML to file for inspection
    file_put_contents('test_heat_cards_output.html', $data['data']);
    echo "\nHTML saved to test_heat_cards_output.html\n";
} else {
    echo "ERROR: {$data['message']}\n";
}
