<?php
// filepath: c:\stylescore2025\htdocs\v2\admin\heat_management_helper.php
/**
 * Heat Management Modal Helper Functions
 */

/**
 * Include heat management modal for use in other pages
 */
function includeHeatManagementModal($event_id, $modal_id = 'heatManagementModal') {
    echo '<div class="modal fade" id="' . htmlspecialchars($modal_id) . '" tabindex="-1" aria-labelledby="' . htmlspecialchars($modal_id) . 'Label" aria-hidden="true">';
    echo '<div class="modal-dialog modal-lg">';
    
    // Set event_id for the modal
    $_GET['event_id'] = $event_id;
    include_once 'heat_management_modal.php';
    
    echo '</div>';
    echo '</div>';
}

/**
 * Generate trigger button for heat management modal
 */
function renderHeatManagementTrigger($event_id, $modal_id = 'heatManagementModal', $button_class = '', $button_text = '') {
    $defaultClass = 'btn btn-primary';
    $finalClass = $button_class ?: $defaultClass;
    $finalText = $button_text ?: '<i class="fas fa-cogs me-1"></i>Heat Management';
    
    echo '<button type="button" class="' . htmlspecialchars($finalClass) . '" data-bs-toggle="modal" data-bs-target="#' . htmlspecialchars($modal_id) . '">';
    echo $finalText;
    echo '</button>';
}

/**
 * Generate floating action button for heat management
 */
function renderHeatManagementFloatingButton($event_id, $modal_id = 'heatManagementModal') {
    echo '<button class="heat-management-trigger" data-bs-toggle="modal" data-bs-target="#' . htmlspecialchars($modal_id) . '" title="Heat Management">';
    echo '<i class="fas fa-cogs"></i>';
    echo '</button>';
    
    // Add required CSS
    echo '<style>';
    echo '.heat-management-trigger {';
    echo '    position: fixed;';
    echo '    bottom: 100px;';
    echo '    right: 30px;';
    echo '    background: linear-gradient(135deg, #28a745, #20c997);';
    echo '    color: white;';
    echo '    border: none;';
    echo '    border-radius: 50%;';
    echo '    width: 60px;';
    echo '    height: 60px;';
    echo '    font-size: 1.5rem;';
    echo '    box-shadow: 0 10px 25px rgba(40, 167, 69, 0.3);';
    echo '    transition: all 0.3s ease;';
    echo '    z-index: 1000;';
    echo '}';
    echo '.heat-management-trigger:hover {';
    echo '    transform: scale(1.1);';
    echo '    box-shadow: 0 15px 35px rgba(40, 167, 69, 0.4);';
    echo '}';
    echo '</style>';
}

/**
 * Load heat management modal via AJAX
 */
function loadHeatManagementModalViaAJAX($containerId, $event_id) {
    echo '<script>';
    echo 'async function loadHeatManagementModal() {';
    echo '    try {';
    echo '        const response = await fetch("heat_management_modal.php?event_id=' . htmlspecialchars($event_id) . '");';
    echo '        const html = await response.text();';
    echo '        document.getElementById("' . htmlspecialchars($containerId) . '").innerHTML = html;';
    echo '    } catch (error) {';
    echo '        console.error("Error loading heat management modal:", error);';
    echo '    }';
    echo '}';
    echo 'loadHeatManagementModal();';
    echo '</script>';
}
?>