<?php
include '../includes/auth.php';
include '../includes/db.php';

header('Content-Type: application/json');

if (!isset($_GET['judge_id'])) {
    echo json_encode(['success' => false, 'message' => 'Judge ID is required']);
    exit;
}

$judge_id = intval($_GET['judge_id']);

try {
    // Fetch events assigned to this judge
    $stmt = $pdo->prepare("
        SELECT e.id, e.name, e.date, e.location, e.description
        FROM events e
        JOIN judge_assignments ja ON e.id = ja.event_id
        WHERE ja.judge_id = ?
        ORDER BY e.date DESC
    ");
    $stmt->execute([$judge_id]);
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'events' => $events
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>