<?php
// Simplified version to test core functionality
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session
if(!isset($_SESSION)) { 
    session_start(); 
}

// Mock session data for testing
$_SESSION['user_type'] = 'head_judge';
$_SESSION['user_logged_in'] = true;

echo "<!DOCTYPE html>\n";
echo "<html><head><title>Head Judge Override - Debug</title></head><body>\n";
echo "<h1>Head Judge Override Panel - Debug Version</h1>\n";

try {
    // Include database
    $host = 'localhost';
    $db = 'freestyle_db';
    $user = 'root';
    $pass = '';
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";
    
    $pdo = new PDO($dsn, $user, $pass);
    echo "<p>✅ Database connected successfully</p>\n";
    
    // Test a simple query
    $events = $pdo->query("SELECT id, name FROM events LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
    echo "<p>✅ Found " . count($events) . " events</p>\n";
    
    foreach ($events as $event) {
        echo "<p>Event: " . htmlspecialchars($event['name']) . " (ID: " . $event['id'] . ")</p>\n";
    }
    
    echo "<p>✅ Basic functionality working. <a href='head_judge_override.php'>Try full version</a></p>\n";
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}

echo "</body></html>\n";
?>
