<!DOCTYPE html>
<html>
<head><title>Debug Form Values</title></head>
<body>
<h2>Debug: Check if PHP values are being set correctly</h2>

<?php
include '../includes/db.php';

$event_id = $_GET['id'] ?? 1;
$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h3>Event ID: $event_id</h3>";
echo "<pre>";
print_r($event);
echo "</pre>";

// Load sports
$sports_stmt = $pdo->prepare("SELECT sport_name FROM figure_sports WHERE is_active = 1 ORDER BY sport_name");
$sports_stmt->execute();
$available_sports = $sports_stmt->fetchAll(PDO::FETCH_COLUMN);

echo "<h3>Test Sport Select:</h3>";
echo '<select id="test_sport" name="sport_discipline">';
echo '<option value="">Select Sport</option>';
foreach ($available_sports as $sport) {
    $isSelected = ($event['sport_discipline'] ?? '') === $sport;
    $selectedAttr = $isSelected ? 'selected="selected"' : '';
    echo "<option value=\"$sport\" $selectedAttr>$sport" . ($isSelected ? ' [SELECTED]' : '') . "</option>";
}
echo '</select>';

echo "<h3>Current selections:</h3>";
echo "Sport: " . ($event['sport_discipline'] ?? 'NONE') . "<br>";
echo "Location: " . ($event['location'] ?? 'NONE') . "<br>";
echo "Format: " . ($event['scoring_format'] ?? 'NONE') . "<br>";

echo "<script>";
echo "console.log('Test sport value:', document.getElementById('test_sport').value);";
echo "console.log('Selected option:', document.getElementById('test_sport').selectedOptions[0]?.text);";
echo "</script>";
?>

</body>
</html>