<?php
// Test to actually generate and examine the dashboard.js file
error_reporting(0);

$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_SCHEME'] = 'http';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/v2/admin/publish_servers.php';

require_once '../includes/db.php';
require_once 'publish_generators.php';

$event_id = 3;
$temp_dir = 'C:/temp/dashboard_debug';
if (!is_dir($temp_dir)) mkdir($temp_dir, 0755, true);

try {
    $files = generateStaticHTMLDashboard($event_id, $temp_dir, $pdo);
    
    // Find dashboard.js
    $dashboard_js = null;
    foreach ($files as $file) {
        if ($file['remote'] === 'dashboard.js') {
            $dashboard_js = $file['local'];
            break;
        }
    }
    
    if ($dashboard_js && file_exists($dashboard_js)) {
        echo "Dashboard.js found at: $dashboard_js\n";
        
        // Read the file and split into lines
        $lines = explode("\n", file_get_contents($dashboard_js));
        
        echo "Total lines: " . count($lines) . "\n";
        
        // Look at lines around 187
        $line_number = 187;
        $start = max(1, $line_number - 5);
        $end = min(count($lines), $line_number + 5);
        
        echo "\nLines around $line_number:\n";
        for ($i = $start; $i <= $end; $i++) {
            $marker = ($i == $line_number) ? ">>> " : "    ";
            echo sprintf("%s%3d: %s\n", $marker, $i, isset($lines[$i-1]) ? $lines[$i-1] : '');
        }
        
        // Search for the specific issue
        echo "\nSearching for 'eventId' issues:\n";
        foreach ($lines as $num => $line) {
            if (strpos($line, 'eventId') !== false && strpos($line, 'function') === false && strpos($line, '=>') === false) {
                $actual_line = $num + 1;
                echo "Line $actual_line: " . trim($line) . "\n";
            }
        }
        
    } else {
        echo "Dashboard.js not found!\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
