<?php
include '../includes/db.php';

echo "<h2>Events Table Data</h2>";

// Get all events with their field values
$stmt = $pdo->query("
    SELECT id, name, location, sport_discipline, scoring_format, scoring_mode, status, date
    FROM events 
    ORDER BY id DESC 
    LIMIT 20
");

$events = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($events)) {
    echo "<p>No events found. Let's create a test event.</p>";
    
    // Insert a test event with proper data
    $stmt = $pdo->prepare("
        INSERT INTO events (
            name, location, sport_discipline, scoring_format, scoring_mode, 
            status, date, max_participants, description
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    $result = $stmt->execute([
        'Test Skateboarding Event',
        'Downtown Skate Park',
        'skateboarding',
        '1', 
        'best',
        'active',
        date('Y-m-d', strtotime('+1 week')),
        50,
        'Test event for form prepopulation'
    ]);
    
    if ($result) {
        $newEventId = $pdo->lastInsertId();
        echo "<p style='color: green;'>✅ Created test event with ID: $newEventId</p>";
        echo "<a href='event_edit.php?id=$newEventId' target='_blank'>Edit Test Event</a>";
    } else {
        echo "<p style='color: red;'>❌ Failed to create test event</p>";
    }
    
} else {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f0f0f0;'>";
    echo "<th>ID</th><th>Name</th><th>Location</th><th>Sport</th><th>Format</th><th>Mode</th><th>Status</th><th>Actions</th>";
    echo "</tr>";
    
    foreach ($events as $event) {
        echo "<tr>";
        echo "<td>{$event['id']}</td>";
        echo "<td>" . htmlspecialchars($event['name'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($event['location'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($event['sport_discipline'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($event['scoring_format'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($event['scoring_mode'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($event['status'] ?? 'NULL') . "</td>";
        echo "<td><a href='event_edit.php?id={$event['id']}' target='_blank'>Edit</a></td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Show available options for reference
echo "<hr><h3>Available Sports in figure_sports:</h3>";
try {
    $sports_stmt = $pdo->query("SELECT sport_name FROM figure_sports WHERE is_active = 1 ORDER BY sport_name");
    $sports = $sports_stmt->fetchAll(PDO::FETCH_COLUMN);
    if (empty($sports)) {
        echo "<p>No sports found. Let's add some:</p>";
        
        // Add basic sports
        $basic_sports = ['skateboarding', 'snowboarding', 'skiing', 'bmx'];
        foreach ($basic_sports as $sport) {
            $stmt = $pdo->prepare("INSERT IGNORE INTO figure_sports (sport_name, is_active) VALUES (?, 1)");
            $stmt->execute([$sport]);
        }
        echo "<p>Added basic sports. Refresh page to see them.</p>";
    } else {
        foreach ($sports as $sport) {
            echo "- $sport<br>";
        }
    }
} catch (Exception $e) {
    echo "<p>Error loading sports: " . $e->getMessage() . "</p>";
}

echo "<h3>Available Formats in scoring_formats:</h3>";
try {
    $formats_stmt = $pdo->query("SELECT format_id, name, sport FROM scoring_formats WHERE is_active = 1 ORDER BY sport, name");
    $formats = $formats_stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($formats)) {
        echo "<p>No formats found. Let's add a basic one:</p>";
        
        $stmt = $pdo->prepare("
            INSERT IGNORE INTO scoring_formats (format_id, name, sport, is_active) 
            VALUES (1, 'Standard Format', 'skateboarding', 1)
        ");
        $stmt->execute();
        echo "<p>Added basic format. Refresh page to see it.</p>";
    } else {
        foreach ($formats as $format) {
            echo "- ID {$format['format_id']}: {$format['name']} ({$format['sport']})<br>";
        }
    }
} catch (Exception $e) {
    echo "<p>Error loading formats: " . $e->getMessage() . "</p>";
}
?>