<?php
require_once '../includes/db.php';

try {
    $pdo->beginTransaction();
    
    // Check if columns exist and add them if they don't
    $columns = [
        'icon_path' => 'VARCHAR(255) NULL',
        'mascot_neutral' => 'VARCHAR(255) NULL',
        'mascot_happy' => 'VARCHAR(255) NULL',
        'mascot_sad' => 'VARCHAR(255) NULL',
        'mascot_asking' => 'VARCHAR(255) NULL'
    ];
    
    foreach ($columns as $columnName => $columnDef) {
        // Check if column exists
        $checkColumn = $pdo->query("SHOW COLUMNS FROM figure_sport_details LIKE '$columnName'");
        if ($checkColumn->rowCount() == 0) {
            // Column doesn't exist, add it
            $pdo->exec("ALTER TABLE figure_sport_details ADD COLUMN $columnName $columnDef");
            echo "Added column: $columnName\n";
        } else {
            echo "Column already exists: $columnName\n";
        }
    }
    
    $pdo->commit();
    echo "Database updated successfully!\n";
    
} catch (PDOException $e) {
    $pdo->rollback();
    echo "Error updating database: " . $e->getMessage() . "\n";
}
?>
