-- Add status columns to judge_assignments table
-- Run this SQL to add judge status functionality

ALTER TABLE `judge_assignments` 
ADD COLUMN `status` VARCHAR(20) DEFAULT 'ready' 
    COMMENT 'Judge status: ready, pending, danger, warning, info, off' 
    AFTER `judge_id`,
ADD COLUMN `status_updated_at` DATETIME NULL 
    COMMENT 'Timestamp when status was last updated' 
    AFTER `status`;

-- Add index for faster status queries
ALTER TABLE `judge_assignments` 
ADD INDEX `idx_status` (`status`),
ADD INDEX `idx_status_updated` (`status_updated_at`);

-- Update existing records to have default 'ready' status
UPDATE `judge_assignments` 
SET `status` = 'ready', 
    `status_updated_at` = NOW() 
WHERE `status` IS NULL;

-- Show the updated table structure
DESCRIBE `judge_assignments`;
