<?php
session_start();
include '../includes/auth_admin.php';
include '../includes/db.php';

$results = $pdo->query("
    SELECT s.judge_id, COUNT(*) as total_scores,
           AVG(s.score_value) as avg_score,
           MIN(s.score_value) as min_score,
           MAX(s.score_value) as max_score
    FROM scores s
    WHERE s.status = 'OK'
    GROUP BY s.judge_id
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Judge Scoring Analytics</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
    <h2>📊 Judge Scoring Analytics</h2>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Judge ID</th>
                <th>Total Scores</th>
                <th>Average</th>
                <th>Min</th>
                <th>Max</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($results as $r): ?>
            <tr>
                <td><?= htmlspecialchars($r['judge_id']) ?></td>
                <td><?= $r['total_scores'] ?></td>
                <td><?= round($r['avg_score'], 2) ?></td>
                <td><?= $r['min_score'] ?></td>
                <td><?= $r['max_score'] ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
