<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);
include '../includes/auth_admin.php';
include '../includes/db.php';

// Fetch event list
$events = $pdo->query("SELECT id, name FROM events")->fetchAll(PDO::FETCH_ASSOC);

// Fetch filters
$categories = $pdo->query("SELECT DISTINCT category FROM participants ORDER BY category")->fetchAll(PDO::FETCH_COLUMN);
$genders = $pdo->query("SELECT DISTINCT gender FROM participants ORDER BY gender")->fetchAll(PDO::FETCH_COLUMN);
$clubs = $pdo->query("SELECT DISTINCT club FROM participants ORDER BY club")->fetchAll(PDO::FETCH_COLUMN);
$years = $pdo->query("SELECT DISTINCT YEAR(date_of_birth) as year FROM participants ORDER BY year DESC")->fetchAll(PDO::FETCH_COLUMN);

// Load participants
$participants = $pdo->query("SELECT id, bip, first_name, last_name, club, category, gender, date_of_birth FROM participants ORDER BY bip ASC")->fetchAll(PDO::FETCH_ASSOC);

// Assign logic
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['assign_participants'])) {
    $event_id = $_POST['event_id'];
    $heat_number = $_POST['heat_number'];
    $participants_to_assign = $_POST['participant_ids'] ?? [];

    foreach ($participants_to_assign as $participant_id) {
        if (!$participant_id) continue;

        $bip_check = $pdo->prepare("
            SELECT COUNT(*) FROM event_participants ep
            JOIN participants p ON ep.participant_id = p.id
            WHERE ep.event_id = ? AND ep.heat_number = ? AND p.bip = (
                SELECT bip FROM participants WHERE id = ?
            )
        ");
        $bip_check->execute([$event_id, $heat_number, $participant_id]);
        if ($bip_check->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO event_participants (event_id, participant_id, heat_number) VALUES (?, ?, ?)");
            $stmt->execute([$event_id, $participant_id, $heat_number]);
        }
    }
}

// Delete single
if (isset($_GET['delete_id'])) {
    $pdo->prepare("DELETE FROM event_participants WHERE id = ?")->execute([(int)$_GET['delete_id']]);
    header("Location: heats_configure.php?event_id=" . (int)$_GET['event_id']);
    exit;
}

// Bulk delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_delete'])) {
    $ids = $_POST['delete_ids'] ?? [];
    if ($ids) {
        $in = implode(',', array_fill(0, count($ids), '?'));
        $pdo->prepare("DELETE FROM event_participants WHERE id IN ($in)")->execute($ids);
    }
    header("Location: heats_configure.php?event_id=" . (int)$_GET['event_id']);
    exit;
}

// Auto assign
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['auto_assign'])) {
    $event_id = $_GET['event_id'];
    $heat_number = $_POST['auto_heat'];
    $ids = explode(',', $_POST['filtered_ids']);
    foreach ($ids as $participant_id) {
        $bip_check = $pdo->prepare("
            SELECT COUNT(*) FROM event_participants ep
            JOIN participants p ON ep.participant_id = p.id
            WHERE ep.event_id = ? AND ep.heat_number = ? AND p.bip = (
                SELECT bip FROM participants WHERE id = ?
            )
        ");
        $bip_check->execute([$event_id, $heat_number, $participant_id]);
        if ($bip_check->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO event_participants (event_id, participant_id, heat_number) VALUES (?, ?, ?)");
            $stmt->execute([$event_id, $participant_id, $heat_number]);
        }
    }
    header("Location: heats_configure.php?event_id=" . $event_id);
    exit;
}

// Current assignments
$assignments = [];
$selected_event = $_GET['event_id'] ?? null;
$heat_filter = $_GET['heat_filter'] ?? null;
if ($selected_event) {
    $query = "
        SELECT ep.id, ep.heat_number, p.bip, p.first_name, p.last_name, p.club, p.category
        FROM event_participants ep
        JOIN participants p ON ep.participant_id = p.id
        WHERE ep.event_id = ?
    ";
    if ($heat_filter) {
        $query .= " AND ep.heat_number = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$selected_event, $heat_filter]);
    } else {
        $stmt = $pdo->prepare($query);
        $stmt->execute([$selected_event]);
    }
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Configure Heats</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
    function filterParticipants() {
        let category = document.getElementById('categoryFilter').value;
        let gender = document.getElementById('genderFilter').value;
        let club = document.getElementById('clubFilter').value;
        let year = document.getElementById('yearFilter').value;
        let options = document.querySelectorAll('#participantSelect option');
        options.forEach(o => {
            let show = true;
            if (category && o.dataset.category !== category) show = false;
            if (gender && o.dataset.gender !== gender) show = false;
            if (club && o.dataset.club !== club) show = false;
            if (year && !o.dataset.date_of_birth.startsWith(year)) show = false;
            o.style.display = show ? 'block' : 'none';
        });
    }
    function collectFiltered() {
        let visible = Array.from(document.querySelectorAll('#participantSelect option'))
            .filter(opt => opt.style.display !== 'none')
            .map(opt => opt.value);
        document.getElementById('autoFilteredIDs').value = visible.join(',');
    }
    </script>
</head>
<body class="p-4 bg-light">
<div class="container">
    <h2>Assign Participants to Heats</h2>
    <form method="get" class="mb-3">
        <label>Event:</label>
        <select name="event_id" class="form-select" onchange="this.form.submit()" required>
            <option value="">-- Choose Event --</option>
            <?php foreach ($events as $event): ?>
                <option value="<?= $event['id'] ?>" <?= $selected_event == $event['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($event['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </form>

    <?php if ($selected_event): ?>
        <form method="post" class="card card-body mb-4" id="ajaxAssignForm" data-event="<?= $selected_event ?>">
            <input type="hidden" name="event_id" value="<?= $selected_event ?>">
            <input type="hidden" name="assign_participants" value="1">
            <div class="row mb-3">
                <div class="col-md-3">
                    <label>Heat Number</label>
                    <input type="number" name="heat_number" class="form-control" required>
                </div>
                <div class="col-md-9">
                    <label>Filters:</label>
                    <div class="row mb-2">
                        <div class="col"><select id="categoryFilter" class="form-select" onchange="filterParticipants()">
                            <option value="">All Categories</option>
                            <?php foreach ($categories as $c): ?><option value="<?= $c ?>"><?= $c ?></option><?php endforeach; ?>
                        </select></div>
                        <div class="col"><select id="genderFilter" class="form-select" onchange="filterParticipants()">
                            <option value="">All Genders</option>
                            <?php foreach ($genders as $g): ?><option value="<?= $g ?>"><?= $g ?></option><?php endforeach; ?>
                        </select></div>
                        <div class="col"><select id="clubFilter" class="form-select" onchange="filterParticipants()">
                            <option value="">All Clubs</option>
                            <?php foreach ($clubs as $c): ?><option value="<?= $c ?>"><?= $c ?></option><?php endforeach; ?>
                        </select></div>
                        <div class="col"><select id="yearFilter" class="form-select" onchange="filterParticipants()">
                            <option value="">All Years</option>
                            <?php foreach ($years as $y): ?><option value="<?= $y ?>"><?= $y ?></option><?php endforeach; ?>
                        </select></div>
                    </div>
                    <select name="participant_ids[]" id="participantSelect" multiple class="form-select" size="10">
                        <?php foreach ($participants as $p): ?>
                            <option value="<?= $p['id'] ?>" data-category="<?= $p['category'] ?>" data-gender="<?= $p['gender'] ?>" data-club="<?= $p['club'] ?>" data-date_of_birth="<?= $p['date_of_birth'] ?>">
                                <?= $p['bip'] ?> - <?= $p['first_name'] ?> <?= $p['last_name'] ?> (<?= $p['club'] ?> / <?= $p['category'] ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <button type="button" id="ajaxAssignBtn" class="btn btn-primary">Assign via AJAX</button>
        </form>

        <form method="post" action="heats_configure.php?event_id=<?= $selected_event ?>" onsubmit="return confirm('Remove selected participants?')">
            <input type="hidden" name="bulk_delete" value="1">
            <button type="submit" class="btn btn-danger mb-3">🗑 Remove Selected</button>
            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th><input type="checkbox" onclick="document.querySelectorAll('.bulk-check').forEach(cb => cb.checked = this.checked)"></th>
                        <th>Heat</th>
                        <th>BIP</th>
                        <th>Name</th>
                        <th>Club</th>
                        <th>Category</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($assignments as $a): ?>
                        <tr>
                            <td><input type="checkbox" name="delete_ids[]" value="<?= $a['id'] ?>" class="bulk-check"></td>
                            <td><?= $a['heat_number'] ?></td>
                            <td><?= $a['bip'] ?></td>
                            <td><?= $a['first_name'] ?> <?= $a['last_name'] ?></td>
                            <td><?= $a['club'] ?></td>
                            <td><?= $a['category'] ?></td>
                            <td>
                                <a href="?delete_id=<?= $a['id'] ?>&event_id=<?= $selected_event ?>" class="btn btn-sm btn-outline-danger">Remove</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </form>

        <div class="mb-4">
            <a href="export_assignments.php?event_id=<?= $selected_event ?>&heat_number=<?= $heat_filter ?>" class="btn btn-outline-success">📤 Export CSV</a>
            <a href="export_assignments_pdf.php?event_id=<?= $selected_event ?>&heat_number=<?= $heat_filter ?>" class="btn btn-outline-danger">🖨 Export PDF</a>
        </div>

        <form method="post" action="heats_configure.php?event_id=<?= $selected_event ?>" onsubmit="collectFiltered(); return confirm('Auto-assign visible participants to this heat?')">
            <input type="hidden" name="auto_assign" value="1">
            <label>Heat Number:</label>
            <input type="number" name="auto_heat" class="form-control w-25 mb-2" required>
            <input type="hidden" name="filtered_ids" id="autoFilteredIDs">
            <button type="submit" class="btn btn-outline-primary">⚡ Auto-Fill Heat from Filtered List</button>
        </form>
    <?php endif; ?>
</div>
<script src="../assets/drag_sort.js"></script>
</body>
</html>
