<?php
session_start();
include '../includes/auth_admin.php';
include '../includes/db.php';

$selected_event = $_GET['event_id'] ?? 0;

// Fetch events list
$events = $pdo->query("SELECT id, name FROM events ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// Fetch filters
$categories = $pdo->query("SELECT DISTINCT category FROM participants WHERE category != ''")->fetchAll(PDO::FETCH_COLUMN);
$genders = $pdo->query("SELECT DISTINCT gender FROM participants WHERE gender != ''")->fetchAll(PDO::FETCH_COLUMN);
$clubs = $pdo->query("SELECT DISTINCT club FROM participants WHERE club != ''")->fetchAll(PDO::FETCH_COLUMN);
$years = $pdo->query("SELECT DISTINCT LEFT(date_of_birth, 4) as year FROM participants WHERE date_of_birth IS NOT NULL")->fetchAll(PDO::FETCH_COLUMN);

// Fetch participants
$participants = $pdo->query("SELECT * FROM participants")->fetchAll(PDO::FETCH_ASSOC);

// Fetch assignments
$assignments = [];
if ($selected_event) {
    $stmt = $pdo->prepare("
        SELECT ep.id, ep.participant_id, ep.heat_number, ep.sort_order, p.bip, p.first_name, p.last_name, p.club, p.category
        FROM event_participants ep
        JOIN participants p ON ep.participant_id = p.id
        WHERE ep.event_id = ?
        ORDER BY ep.sort_order ASC
    ");
    $stmt->execute([$selected_event]);
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Configure Heats</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
    tr.dragging { opacity: 0.5; }
    tr.locked { background-color: #f8f9fa !important; }
    </style>
</head>
<body class="p-4 bg-light">
<div class="container">
    <h2>Configure Heats</h2>
    <form method="get" class="mb-3">
        <label>Select Event:</label>
        <select name="event_id" class="form-select" onchange="this.form.submit()">
            <option value="">-- Select Event --</option>
            <?php foreach ($events as $e): ?>
                <option value="<?= $e['id'] ?>" <?= ($e['id'] == $selected_event ? 'selected' : '') ?>>
                    <?= htmlspecialchars($e['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </form>

    <?php if ($selected_event): ?>
        <table class="table table-bordered bg-white">
            <thead>
                <tr>
                    <th>#</th><th>Heat</th><th>BIP</th><th>Name</th><th>Club</th><th>Category</th>
                </tr>
            </thead>
            <tbody id="sortable-body">
                <?php foreach ($assignments as $i => $a): ?>
                    <tr data-id="<?= $a['id'] ?>" class="<?= $a['locked'] ?? 0 ? 'locked' : '' ?>">
                        <td class="order-number"><?= $i + 1 ?></td>
                        <td><?= $a['heat_number'] ?></td>
                        <td><?= $a['bip'] ?></td>
                        <td><?= $a['first_name'] ?> <?= $a['last_name'] ?></td>
                        <td><?= $a['club'] ?></td>
                        <td><?= $a['category'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const tbody = document.querySelector("#sortable-body");
    let draggingEle, x = 0, y = 0, placeholder, isDraggingStarted = false;

    const swap = (nodeA, nodeB) => {
        const parentA = nodeA.parentNode;
        const siblingA = nodeA.nextSibling === nodeB ? nodeA : nodeA.nextSibling;
        nodeB.parentNode.insertBefore(nodeA, nodeB);
        parentA.insertBefore(nodeB, siblingA);
    };

    const isAbove = (nodeA, nodeB) => {
        const rectA = nodeA.getBoundingClientRect();
        const rectB = nodeB.getBoundingClientRect();
        return (rectA.top + rectA.height / 2) < (rectB.top + rectB.height / 2);
    };

    const mouseDownHandler = function(e) {
        const row = e.target.closest("tr");
        if (!row || row.classList.contains("locked")) return;

        draggingEle = row;
        const rect = draggingEle.getBoundingClientRect();
        placeholder = document.createElement("tr");
        placeholder.classList.add("placeholder");
        placeholder.innerHTML = '<td colspan="6" style="height: 40px; background: #f0f0f0;"></td>';
        draggingEle.parentNode.insertBefore(placeholder, draggingEle.nextSibling);
        draggingEle.classList.add("dragging");

        x = e.clientX;
        y = e.clientY;

        document.addEventListener("mousemove", mouseMoveHandler);
        document.addEventListener("mouseup", mouseUpHandler);
    };

    const mouseMoveHandler = function(e) {
        const draggingRect = draggingEle.getBoundingClientRect();
        draggingEle.style.position = 'absolute';
        draggingEle.style.top = `${e.clientY}px`;
        draggingEle.style.left = `${draggingRect.left}px`;

        const prev = placeholder.previousElementSibling;
        const next = placeholder.nextElementSibling;

        if (prev && isAbove(draggingEle, prev)) swap(placeholder, prev);
        if (next && !isAbove(draggingEle, next)) swap(next, placeholder);
    };

    const mouseUpHandler = function() {
        placeholder.parentNode.insertBefore(draggingEle, placeholder);
        draggingEle.classList.remove("dragging");
        placeholder.remove();
        draggingEle.style.removeProperty("top");
        draggingEle.style.removeProperty("left");
        draggingEle.style.removeProperty("position");

        document.removeEventListener("mousemove", mouseMoveHandler);
        document.removeEventListener("mouseup", mouseUpHandler);

        const order = [];
        tbody.querySelectorAll("tr").forEach((tr, index) => {
            tr.querySelector(".order-number").textContent = index + 1;
            order.push({ id: tr.dataset.id, sort: index + 1 });
        });

        fetch("save_sort_order.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(order)
        }).then(r => {
            if (!r.ok) alert("Failed to save order");
        });
    };

    tbody.querySelectorAll("tr:not(.locked)").forEach(row => {
        row.addEventListener("mousedown", mouseDownHandler);
    });
});
</script>
</body>
</html>
