<?php
// Check existing database structure
try {
    require_once '../includes/db.php';
    echo "<h3>Current Database Structure</h3>";
    
    // Show all tables
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<h4>Existing Tables:</h4>";
    foreach ($tables as $table) {
        echo "- $table<br>";
    }
    
    // Check if events table exists and show its structure
    if (in_array('events', $tables)) {
        echo "<h4>Events Table Structure:</h4>";
        $columns = $pdo->query("DESCRIBE events")->fetchAll(PDO::FETCH_ASSOC);
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td>{$col['Field']}</td>";
            echo "<td>{$col['Type']}</td>";
            echo "<td>{$col['Null']}</td>";
            echo "<td>{$col['Key']}</td>";
            echo "<td>{$col['Default']}</td>";
            echo "<td>{$col['Extra']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Show sample data
        $events = $pdo->query("SELECT * FROM events LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
        if ($events) {
            echo "<h4>Sample Events Data:</h4>";
            echo "<pre>" . print_r($events, true) . "</pre>";
        }
    }
    
    // Check participants table if it exists
    if (in_array('participants', $tables)) {
        echo "<h4>Participants Table Structure:</h4>";
        $columns = $pdo->query("DESCRIBE participants")->fetchAll(PDO::FETCH_ASSOC);
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td>{$col['Field']}</td>";
            echo "<td>{$col['Type']}</td>";
            echo "<td>{$col['Null']}</td>";
            echo "<td>{$col['Key']}</td>";
            echo "<td>{$col['Default']}</td>";
            echo "<td>{$col['Extra']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "<br>";
    echo "Error Code: " . $e->getCode() . "<br>";
}
?>
