# StyleScore TV Overlay System

A comprehensive broadcast overlay control system for live scoring display on television, streaming, and digital signage.

## 🎯 Features

### **Remote Control Panel**
- **Multiple Overlay Types**: Lower thirds, rankings, top 3 podium, start lists, judge scores
- **Flexible Positioning**: 9-point positioning system (corners, edges, center)
- **Real-time Control**: Instant show/hide, participant switching, data refresh
- **Animation Options**: Slide, fade, flip, zoom animations
- **Auto-scaling**: Responsive scaling from 50% to 150% for different display sizes

### **Lower Third Graphics**
- **Participant Information**: Name, country, bib number, category
- **Live Scoring**: Current score, best score, current ranking
- **Event Context**: Event name, discipline, run information
- **Visual Branding**: Consistent StyleScore branding with gradient elements

### **Animated Results Tables**
- **Live Rankings**: Real-time leaderboard with auto-refresh
- **Smooth Animations**: Staggered row animations, flip effects
- **Auto-pagination**: Configurable display limits (Top 5, Top 10, etc.)
- **Color-coded Rankings**: Gold/Silver/Bronze highlighting for podium positions

### **Broadcast Integration**
- **Fullscreen Mode**: Dedicated overlay window for broadcast software
- **Transparent Background**: Clean overlay over video content
- **Multiple Resolutions**: Auto-adapts to 1080p, 1440p, 4K displays
- **Keyboard Shortcuts**: Quick control via hotkeys

## 🚀 Quick Start

### **Setup**
1. Copy the `tv-overlay` folder to your StyleScore installation
2. Access the control panel: `http://yoursite.com/v2/tv-overlay/`
3. Select your event from the dropdown
4. Choose overlay type and position

### **Basic Usage**
1. **Lower Third**: Show current participant with live scores
2. **Rankings**: Display live leaderboard (Top 5, Top 10, or full)
3. **Podium**: Show Top 3 results with podium visualization
4. **Position Control**: Click position grid to move overlay
5. **Show/Hide**: Use control buttons or keyboard shortcuts

### **Broadcast Setup**
1. Click "Fullscreen" to open dedicated overlay window
2. Use this window as browser source in OBS/vMix/etc.
3. Set to 1920x1080 resolution for HD broadcast
4. Enable browser source transparency

## 🎮 Controls

### **Overlay Types**
- **Ctrl+1**: Lower Third - Current Participant
- **Ctrl+2**: Live Rankings
- **Ctrl+3**: Top 3 Podium
- **Ctrl+H**: Hide All Overlays
- **Ctrl+S**: Show Current Overlay

### **Participant Navigation**
- **Ctrl+→**: Next Participant
- **Ctrl+←**: Previous Participant

### **Panel Controls**
- **Event Selection**: Choose active event
- **Position Grid**: 9-point positioning system
- **Animation Type**: Slide, Fade, Flip, Zoom
- **Display Duration**: Auto-hide timer (1-60 seconds)
- **Auto-Update**: Refresh interval (5s, 10s, 30s)
- **Scale Control**: 50% to 150% sizing

## 📺 Overlay Types

### **1. Lower Third**
Perfect for introducing athletes during competition:
- Participant name with gradient styling
- Country flag and bib number
- Current score, best score, ranking
- Event and run information
- Customizable positioning

### **2. Live Rankings**
Real-time leaderboard display:
- Animated row updates
- Color-coded podium positions
- Country abbreviations
- Live score updates
- Configurable participant limits

### **3. Top 3 Podium**
Podium-style results display:
- Medal position styling (Gold/Silver/Bronze)
- Step-height visualization
- Participant names and scores
- Perfect for final results

### **4. Judge Scores**
Individual judge scoring breakdown:
- Per-judge component scores
- Real-time score entry display
- Component-based scoring
- Judge identification

### **5. Start List**
Upcoming participants display:
- Start order visualization
- Participant information
- Heat organization
- Category grouping

## ⚙️ API Integration

### **Real-time Data Endpoints**
```
GET /tv-overlay/api.php?action=participants&event_id=123
GET /tv-overlay/api.php?action=rankings&event_id=123&limit=10
GET /tv-overlay/api.php?action=participant_detail&event_id=123&participant_id=456
GET /tv-overlay/api.php?action=live_scores&event_id=123
GET /tv-overlay/api.php?action=judge_scores&event_id=123&participant_id=456
```

### **Data Structure**
```json
{
  "participant": {
    "id": 123,
    "name": "John Smith",
    "country": "USA",
    "bib": "#42",
    "category": "Men's Open"
  },
  "scores": {
    "current": 87.50,
    "best": 89.25,
    "runs": [...]
  },
  "rank": {
    "position": 2,
    "ordinal": "2nd"
  }
}
```

## 🎨 Customization

### **Styling**
- Modify CSS variables in `overlay-display.php` for custom branding
- Adjust gradient colors, fonts, and animations
- Responsive breakpoints for different display sizes

### **Animations**
- Slide: Smooth slide-in transitions
- Fade: Opacity-based transitions
- Flip: 3D flip animations
- Zoom: Scale-based transitions

### **Positioning**
- 9-point grid system for precise placement
- Automatic responsive adjustments
- Custom positioning via CSS classes

## 🔧 Technical Requirements

### **Server Requirements**
- PHP 7.4+ with PDO extension
- StyleScore database access
- Modern web server (Apache/Nginx)

### **Browser Requirements**
- Chrome 90+ (recommended for broadcast)
- Firefox 88+
- Safari 14+
- Hardware acceleration enabled

### **Broadcasting Software**
- **OBS Studio**: Browser source with custom CSS
- **vMix**: Web browser input
- **Wirecast**: Web page layer
- **XSplit**: Browser source

## 📱 Mobile Control

The control panel is fully responsive and works on:
- Tablets (iPad, Android tablets)
- Phones (iOS, Android)
- Touch-enabled laptops

Perfect for remote control during live events.

## 🔄 Auto-Update Features

### **Real-time Synchronization**
- 5-second data refresh intervals
- Live score updates
- Participant status changes
- Ranking recalculations

### **Smart Caching**
- Optimized API calls
- Local data caching
- Bandwidth-efficient updates

## 🎯 Use Cases

### **Live Events**
- Snowboard/Freeski competitions
- Skateboarding contests
- Surf competitions
- BMX events
- Action sports festivals

### **Broadcast Integration**
- Television broadcasts
- Live streaming
- Digital signage
- Venue displays
- Social media graphics

### **Remote Operation**
- Control from judge booth
- Operator stations
- Mobile devices
- Backup control systems

## 🚨 Troubleshooting

### **Common Issues**
1. **Overlay not appearing**: Check browser permissions and network connectivity
2. **Outdated scores**: Verify API endpoint connectivity
3. **Positioning issues**: Refresh overlay display and reset position
4. **Performance**: Enable hardware acceleration in browser settings

### **Browser Setup for Broadcasting**
1. Disable browser notifications
2. Enable hardware acceleration
3. Set zoom to 100%
4. Clear cache before important broadcasts

---

*Built for StyleScore - Professional Action Sports Scoring*
