<?php
// Test scoring layout integration
require_once 'includes/db.php';
require_once 'includes/ScoringLayoutConfig.php';

echo "<h2>Testing Scoring Layout Integration</h2>";

// Test with a sample event (adjust event_id as needed)
$test_event_id = 1; // Change this to an actual event ID in your database
$test_heat = 1;

echo "<h3>Testing Configuration Loading</h3>";

try {
    $config = ScoringLayoutConfig::getEffectiveConfig($pdo, $test_event_id, $test_heat);
    
    echo "<strong>Configuration loaded:</strong><br>";
    echo "<pre>" . print_r($config, true) . "</pre>";
    
    echo "<h3>Testing Component Checks</h3>";
    
    $components = [
        'criteria-input-grid',
        'final-calculated-score', 
        'figures-card',
        'score-history-table',
        'participant-selection',
        'submit-button-section',
        'heat-run-navigation',
        'diversity-validation-panel'
    ];
    
    foreach ($components as $component) {
        $enabled = ScoringLayoutConfig::isComponentEnabled($config, $component);
        echo "• {$component}: " . ($enabled ? "<span style='color:green'>ENABLED</span>" : "<span style='color:red'>DISABLED</span>") . "<br>";
    }
    
    echo "<h3>Testing Generated JavaScript</h3>";
    $script = ScoringLayoutConfig::generateApplyScript($config);
    echo "<strong>Generated script:</strong><br>";
    echo "<pre>" . htmlspecialchars($script) . "</pre>";
    
} catch (Exception $e) {
    echo "<strong>Error:</strong> " . $e->getMessage();
}
?>