<?php
// Simple test of the publish server functionality
require_once 'includes/db.php';

echo "Testing basic publish server functionality...\n";

// Test if we can load the publish_servers page without errors
try {
    // Simulate a basic POST request structure
    $_POST = [
        'action' => 'test',
        'event_id' => 3
    ];
    $_SERVER['REQUEST_METHOD'] = 'POST';
    
    echo "POST data structure looks good.\n";
    
    // Try to include the file and see if it throws errors
    ob_start();
    include 'admin/publish_servers.php';
    $output = ob_get_clean();
    
    echo "Page loaded successfully.\n";
    echo "Output length: " . strlen($output) . " bytes\n";
    
    // Check if output looks like valid JSON or HTML
    if (strpos($output, '{') === 0) {
        echo "Output appears to be JSON\n";
        $json = json_decode($output, true);
        if ($json === null) {
            echo "ERROR: Invalid JSON output\n";
            echo "First 200 chars of output: " . substr($output, 0, 200) . "\n";
        } else {
            echo "Valid JSON response\n";
        }
    } else if (strpos($output, '<') === 0) {
        echo "Output appears to be HTML\n";
    } else {
        echo "Unexpected output format\n";
        echo "First 200 chars: " . substr($output, 0, 200) . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "Test complete.\n";
?>
