<?php
// Simple test script to check judge scores output
$_GET = [
    'event_id' => '3',
    'category' => 'Jump 1',
    'show_judges' => 'true',
    'show_runs' => 'false',
    'show_heat_best' => 'false', 
    'show_heat_average' => 'false',
    'show_overall_best' => 'false',
    'show_highest_average' => 'false',
    'show_control_points' => 'false',
    'show_figures' => 'false'
];

// Capture output
ob_start();
include 'api/summary_table_api.php';
$output = ob_get_clean();

$data = json_decode($output, true);

if (isset($data['data']) && !empty($data['data'])) {
    echo "Judge scores output:\n";
    foreach ($data['data'] as $participant) {
        echo "Participant: " . $participant['Participant'] . "\n";
        // Look for judge columns
        foreach ($participant as $key => $value) {
            if (preg_match('/H\d+R\d+_judges/', $key)) {
                echo "  $key: $value\n";
            }
        }
        echo "\n";
        break; // Just show first participant
    }
} else {
    echo "Error or no data:\n";
    echo substr($output, 0, 500) . "\n";
}
?>
