<?php
require_once 'includes/db.php';

try {
    $stmt = $pdo->prepare("SELECT event_id, heat_number, heat_name, runs_scoring_method FROM heat_settings WHERE event_id = 6");
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Heat Settings for Event 6:\n";
    echo "============================\n";
    foreach ($results as $row) {
        echo "Heat {$row['heat_number']}: {$row['heat_name']}\n";
        echo "  Scoring Method: {$row['runs_scoring_method']}\n\n";
    }
    
    // Also check the actual scores
    echo "\n\nActual Scores for BIB 6:\n";
    echo "========================\n";
    $stmt = $pdo->prepare("
        SELECT sr.heat_number, sr.run_number, sr.judge_id, sr.total_score, j.first_name, j.last_name
        FROM scoring_results sr
        LEFT JOIN judges j ON sr.judge_id = j.judge_id
        WHERE sr.event_id = 6 
        AND sr.participant_id = (SELECT participant_id FROM event_participants WHERE event_id = 6 AND bib_number = 6)
        ORDER BY sr.heat_number, sr.run_number, sr.judge_id
    ");
    $stmt->execute();
    $scores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($scores as $score) {
        echo "H{$score['heat_number']}R{$score['run_number']} - Judge: {$score['first_name']} {$score['last_name']} (ID: {$score['judge_id']}) - Score: {$score['total_score']}\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
