<?php
require_once 'includes/db.php';

echo "Event Heat Settings for Event 6:\n";
echo "================================\n";
$stmt = $pdo->prepare("SELECT * FROM event_heat_settings WHERE event_id = 6");
$stmt->execute();
$settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($settings as $setting) {
    echo "Heat {$setting['heat_number']}: {$setting['heat_name']}\n";
    echo "  Runs Scoring Method: {$setting['runs_scoring_method']}\n";
    echo "  Runs Count: {$setting['runs_count']}\n\n";
}

// Also check the actual scores for BIB 6
echo "\n\nActual Scores for BIB 6 (Guziak Andrzej):\n";
echo "==========================================\n";
$stmt = $pdo->prepare("
    SELECT sr.heat_number, sr.run_number, sr.judge_id, sr.total_score, j.first_name, j.last_name
    FROM scoring_results sr
    LEFT JOIN judges j ON sr.judge_id = j.judge_id
    WHERE sr.event_id = 6 
    AND sr.participant_id = (SELECT participant_id FROM event_participants WHERE event_id = 6 AND bib_number = 6)
    ORDER BY sr.heat_number, sr.run_number, sr.judge_id
");
$stmt->execute();
$scores = $stmt->fetchAll(PDO::FETCH_ASSOC);

$grouped = [];
foreach ($scores as $score) {
    $key = "H{$score['heat_number']}R{$score['run_number']}";
    if (!isset($grouped[$key])) {
        $grouped[$key] = [];
    }
    $grouped[$key][] = $score['total_score'];
}

foreach ($grouped as $key => $scores_array) {
    $avg = array_sum($scores_array) / count($scores_array);
    echo "$key: " . implode(', ', $scores_array) . " -> Average: $avg\n";
}
