<?php
require 'includes/db.php';

echo "Participants by Heat for Event 6:\n\n";

$stmt = $pdo->query("
    SELECT ep.heat_number, ep.bib_number, p.first_name, p.last_name, ep.category
    FROM event_participants ep
    JOIN participants p ON ep.participant_id = p.id
    WHERE ep.event_id = 6
    ORDER BY ep.heat_number, ep.bib_number
");

$current_heat = null;
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    if ($current_heat !== $row['heat_number']) {
        $current_heat = $row['heat_number'];
        echo "\n=== Heat {$current_heat} ===\n";
    }
    echo "  BIB {$row['bib_number']}: {$row['first_name']} {$row['last_name']} ({$row['category']})\n";
}
