<?php
require_once 'includes/db.php';

try {
    // Get available events
    $stmt = $pdo->query("SELECT id, name FROM events ORDER BY id DESC LIMIT 1");
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (!empty($events)) {
        $event_id = $events[0]['id'];
        echo "Generating static dashboard for event {$event_id}: {$events[0]['name']}\n";
        
        // Create admin context to avoid path issues
        chdir(__DIR__ . '/admin');
        require_once 'publish_generators.php';
        
        // Create temp directory
        $temp_dir = sys_get_temp_dir() . '/stylescore_full_test_' . time();
        mkdir($temp_dir, 0755, true);
        echo "Created temp directory: $temp_dir\n";
        
        // Generate the dashboard files
        $files = generateStaticHTMLDashboard($event_id, $temp_dir, $pdo);
        
        echo "Generated " . count($files) . " files:\n";
        foreach ($files as $file) {
            echo "- " . basename($file['remote']) . " (" . filesize($file['local']) . " bytes)\n";
        }
        
        // Copy main dashboard file for testing
        $dashboard_file = $temp_dir . '/index.html';
        if (file_exists($dashboard_file)) {
            copy($dashboard_file, __DIR__ . '/static_dashboard_with_reports.html');
            echo "\nSuccess! Dashboard copied to: static_dashboard_with_reports.html\n";
            echo "View it at: http://localhost/v2/static_dashboard_with_reports.html\n";
            echo "\n🎉 NEW FEATURES ADDED:\n";
            echo "✅ Report cards with live loading\n";
            echo "✅ FLIP animations for row position changes\n";
            echo "✅ AJAX data loading without page refresh\n";
            echo "✅ Auto-refresh with pause/resume controls\n";
            echo "✅ General Reports and Heat-specific reports\n";
            echo "✅ Start lists and summary tables\n";
            echo "✅ Same functionality as public_event_dashboard.php\n";
        } else {
            echo "\nError: dashboard.html was not found in temp directory\n";
            echo "Available files in temp dir:\n";
            $temp_files = scandir($temp_dir);
            foreach ($temp_files as $tf) {
                if ($tf !== '.' && $tf !== '..') {
                    echo "  - $tf\n";
                }
            }
        }
        
    } else {
        echo "No events found in database\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
}
?>
