<?php
include 'includes/db.php';

echo "<h1>Test Events Layout Configuration Loading</h1>";

foreach ([1, 3] as $event_id) {
    echo "<h2>Event $event_id Test:</h2>";
    
    // Load the configuration the same way as score.php
    $scoring_layout_config = null;
    try {
        $layout_stmt = $pdo->prepare("SELECT scoring_layout_config FROM events WHERE id = ?");
        $layout_stmt->execute([$event_id]);
        $layout_config_json = $layout_stmt->fetchColumn();
        
        if ($layout_config_json) {
            $scoring_layout_config = json_decode($layout_config_json, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                echo "<p style='color: red;'>❌ Invalid JSON for event $event_id</p>";
            }
        }
    } catch (Exception $e) {
        echo "<p style='color: red;'>❌ Error loading config: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
    
    if ($scoring_layout_config) {
        echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px;'>";
        echo "<p><strong>✅ Configuration loaded successfully!</strong></p>";
        echo "<pre>" . json_encode($scoring_layout_config, JSON_PRETTY_PRINT) . "</pre>";
        
        echo "<h4>Component Visibility Test:</h4>";
        foreach ($scoring_layout_config as $componentKey => $isVisible) {
            $color = $isVisible ? '#4caf50' : '#f44336';
            $symbol = $isVisible ? '✅' : '❌';
            echo "<div style='color: $color; margin: 5px 0;'>$symbol <strong>$componentKey:</strong> " . ($isVisible ? 'VISIBLE' : 'HIDDEN') . "</div>";
        }
        echo "</div>";
        
        // Test the PHP conditions
        echo "<h4>PHP Condition Tests:</h4>";
        echo "<div style='font-family: monospace; background: #f5f5f5; padding: 10px; border-radius: 5px;'>";
        
        $criteria_visible = (!$scoring_layout_config || ($scoring_layout_config['criteria-input-grid'] ?? true));
        echo "<div>criteria-input-grid visible: " . ($criteria_visible ? 'YES' : 'NO') . "</div>";
        
        $figures_visible = (!$scoring_layout_config || ($scoring_layout_config['figures-card'] ?? true));
        echo "<div>figures-card visible: " . ($figures_visible ? 'YES' : 'NO') . "</div>";
        
        echo "</div>";
        
    } else {
        echo "<p style='background: #fff3cd; padding: 10px; border-radius: 5px;'>⚠️ No configuration found - will show default layout</p>";
    }
    
    echo "<hr>";
}

echo "<h2>🧪 Direct Test Links:</h2>";
echo "<a href='judge/score.php?event_id=1&heat_number=1' target='_blank' style='background: #4caf50; color: white; padding: 10px 20px; text-decoration: none; margin: 10px; border-radius: 5px;'>Event 1 Judge Panel</a>";
echo "<a href='judge/score.php?event_id=3&heat_number=1' target='_blank' style='background: #f44336; color: white; padding: 10px 20px; text-decoration: none; margin: 10px; border-radius: 5px;'>Event 3 Judge Panel</a>";
?>