<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/db.php';

try {
    echo "Connected to database\n\n";
    
    // Get all events
    $stmt = $pdo->query("SELECT event_id, event_name, scoring_format_id FROM events");
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Total events: " . count($events) . "\n\n";
    
    foreach ($events as $e) {
        if ($e['event_id'] == 6) {
            echo "FOUND Event 6:\n";
            print_r($e);
            
            if ($e['scoring_format_id']) {
                $stmt2 = $pdo->prepare("SELECT * FROM scoring_formats WHERE format_id = ?");
                $stmt2->execute([$e['scoring_format_id']]);
                $format = $stmt2->fetch(PDO::FETCH_ASSOC);
                
                echo "\nScoring Format:\n";
                print_r($format);
            }
        }
    }
} catch (Exception $ex) {
    echo "ERROR: " . $ex->getMessage() . "\n";
    echo $ex->getTraceAsString();
}
