<?php
require_once 'includes/db.php';

$stmt = $pdo->prepare("SELECT id, view_name, configuration FROM result_configurations WHERE id = 74");
$stmt->execute();
$config = $stmt->fetch(PDO::FETCH_ASSOC);

echo "Config ID: " . $config['id'] . "\n";
echo "View Name: " . $config['view_name'] . "\n";
echo "Configuration JSON:\n";
echo $config['configuration'] . "\n\n";

$settings = json_decode($config['configuration'], true);
echo "Parsed Configuration:\n";
print_r($settings);

echo "\n\nHeat Direction Setting: ";
echo isset($settings['heatDirection']) ? $settings['heatDirection'] : 'NOT SET (will default to row)';
echo "\n";
