<?php
include 'includes/db.php';

echo "<h1>🎯 Complete Judge Panel Layout Test</h1>";

// Update Event 3 with comprehensive minimal layout
$minimalConfig = [
    'format-info' => false,            // HIDE format information
    'participant-selection' => true,   // SHOW participant selection 
    'other-heat-scores' => false,      // HIDE other heat scores
    'criteria-input-grid' => false,    // HIDE criteria input grid
    'final-calculated-score' => true,  // SHOW final score
    'figures-card' => false,           // HIDE figures card
    'diversity-validation' => false,   // HIDE diversity validation
    'latest-scores' => false,          // HIDE latest scores table
    'figure-history' => false,         // HIDE figure history
    'submit-button' => true            // SHOW submit button
];

// Update Event 1 with full layout
$fullConfig = [
    'format-info' => true,             // SHOW format information
    'participant-selection' => true,   // SHOW participant selection
    'other-heat-scores' => true,       // SHOW other heat scores
    'criteria-input-grid' => true,     // SHOW criteria input grid
    'final-calculated-score' => true,  // SHOW final score
    'figures-card' => true,            // SHOW figures card
    'diversity-validation' => true,    // SHOW diversity validation
    'latest-scores' => true,           // SHOW latest scores table
    'figure-history' => true,          // SHOW figure history
    'submit-button' => true            // SHOW submit button
];

try {
    $stmt = $pdo->prepare("UPDATE events SET scoring_layout_config = ? WHERE id = ?");
    
    // Update Event 1 - Full Layout
    $stmt->execute([json_encode($fullConfig), 1]);
    echo "<div style='background: #d1e7dd; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>✅ Event 1 - Full Layout Configuration Applied</h3>";
    echo "<p>All components will be visible</p>";
    echo "</div>";
    
    // Update Event 3 - Minimal Layout
    $stmt->execute([json_encode($minimalConfig), 3]);
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
    echo "<h3>🎯 Event 3 - Minimal Layout Configuration Applied</h3>";
    echo "<p>Only essential components will be visible</p>";
    echo "</div>";
    
    echo "<h2>📊 Layout Configuration Comparison</h2>";
    
    echo "<div style='display: flex; gap: 20px; margin: 20px 0;'>";
    
    // Event 1 - Full Layout
    echo "<div style='flex: 1; background: #d1e7dd; padding: 15px; border-radius: 5px;'>";
    echo "<h3 style='color: #0f5132;'>Event 1 - Full Layout</h3>";
    echo "<h4>✅ VISIBLE Components:</h4>";
    echo "<ul>";
    foreach ($fullConfig as $component => $visible) {
        if ($visible) {
            echo "<li style='color: #0f5132;'><strong>$component</strong></li>";
        }
    }
    echo "</ul>";
    echo "</div>";
    
    // Event 3 - Minimal Layout
    echo "<div style='flex: 1; background: #f8d7da; padding: 15px; border-radius: 5px;'>";
    echo "<h3 style='color: #842029;'>Event 3 - Minimal Layout</h3>";
    echo "<h4>✅ VISIBLE Components:</h4>";
    echo "<ul>";
    $visibleCount = 0;
    foreach ($minimalConfig as $component => $visible) {
        if ($visible) {
            echo "<li style='color: #0f5132;'><strong>$component</strong></li>";
            $visibleCount++;
        }
    }
    echo "</ul>";
    echo "<h4 style='color: #842029;'>❌ HIDDEN Components:</h4>";
    echo "<ul>";
    foreach ($minimalConfig as $component => $visible) {
        if (!$visible) {
            echo "<li style='color: #842029;'>$component</li>";
        }
    }
    echo "</ul>";
    echo "<p><strong>Reduction: " . (count($minimalConfig) - $visibleCount) . " components hidden</strong></p>";
    echo "</div>";
    
    echo "</div>";
    
    echo "<h2>🧪 Test Both Configurations</h2>";
    echo "<div style='text-align: center; margin: 30px 0;'>";
    
    echo "<a href='judge/score.php?event_id=1&heat_number=1' target='_blank' ";
    echo "style='background: #198754; color: white; padding: 20px 40px; text-decoration: none; ";
    echo "font-weight: bold; border-radius: 10px; margin: 20px; display: inline-block; ";
    echo "font-size: 18px; box-shadow: 0 4px 8px rgba(0,0,0,0.2);'>";
    echo "🟢 EVENT 1 - FULL LAYOUT<br><small style='opacity: 0.8;'>All 10 components visible</small></a>";
    
    echo "<br><br>";
    
    echo "<a href='judge/score.php?event_id=3&heat_number=1' target='_blank' ";
    echo "style='background: #dc3545; color: white; padding: 20px 40px; text-decoration: none; ";
    echo "font-weight: bold; border-radius: 10px; margin: 20px; display: inline-block; ";
    echo "font-size: 18px; box-shadow: 0 4px 8px rgba(0,0,0,0.2);'>";
    echo "🔴 EVENT 3 - MINIMAL LAYOUT<br><small style='opacity: 0.8;'>Only 3 essential components</small></a>";
    
    echo "</div>";
    
    echo "<h2>📋 Configuration Details</h2>";
    echo "<table style='width: 100%; border-collapse: collapse; margin: 20px 0;'>";
    echo "<tr style='background: #f8f9fa;'>";
    echo "<th style='padding: 15px; border: 1px solid #ddd;'>Component</th>";
    echo "<th style='padding: 15px; border: 1px solid #ddd;'>Event 1 (Full)</th>";
    echo "<th style='padding: 15px; border: 1px solid #ddd;'>Event 3 (Minimal)</th>";
    echo "<th style='padding: 15px; border: 1px solid #ddd;'>Description</th>";
    echo "</tr>";
    
    $descriptions = [
        'format-info' => 'Event format rules and configuration details',
        'participant-selection' => 'Participant selection dropdown and BIB input',
        'other-heat-scores' => 'Scores from other judges in the same heat',
        'criteria-input-grid' => 'Main scoring criteria input fields',
        'final-calculated-score' => 'Final calculated score display',
        'figures-card' => 'Figure selection interface for technical events',
        'diversity-validation' => 'Figure diversity rule validation display',
        'latest-scores' => 'Recent scores submitted by this judge',
        'figure-history' => 'Previously selected figures across runs',
        'submit-button' => 'Score submission button and controls'
    ];
    
    foreach ($fullConfig as $component => $fullVisible) {
        $minimalVisible = $minimalConfig[$component];
        $description = $descriptions[$component] ?? 'Component description';
        
        echo "<tr>";
        echo "<td style='padding: 12px; border: 1px solid #ddd; font-weight: bold;'>$component</td>";
        
        $fullColor = $fullVisible ? '#198754' : '#dc3545';
        $fullText = $fullVisible ? '✅ SHOW' : '❌ HIDE';
        echo "<td style='padding: 12px; border: 1px solid #ddd; color: $fullColor; font-weight: bold;'>$fullText</td>";
        
        $minimalColor = $minimalVisible ? '#198754' : '#dc3545';
        $minimalText = $minimalVisible ? '✅ SHOW' : '❌ HIDE';
        echo "<td style='padding: 12px; border: 1px solid #ddd; color: $minimalColor; font-weight: bold;'>$minimalText</td>";
        
        echo "<td style='padding: 12px; border: 1px solid #ddd; color: #6c757d;'>$description</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<div style='background: #e3f2fd; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h3>💡 Testing Instructions:</h3>";
    echo "<ol>";
    echo "<li><strong>Open Event 1:</strong> You should see a comprehensive judge interface with all scoring components</li>";
    echo "<li><strong>Open Event 3:</strong> You should see a streamlined interface with only participant selection, final score, and submit button</li>";
    echo "<li><strong>Compare Side-by-Side:</strong> Open both in separate browser tabs to see the dramatic difference</li>";
    echo "<li><strong>Check Console:</strong> Open browser developer tools to see layout configuration being applied</li>";
    echo "</ol>";
    echo "</div>";
    
    // Add database verification
    echo "<h3>🔍 Database Verification:</h3>";
    $verifyStmt = $pdo->query("SELECT id, name, scoring_layout_config FROM events WHERE id IN (1, 3) ORDER BY id");
    while ($row = $verifyStmt->fetch()) {
        echo "<h4>Event " . $row['id'] . " (" . htmlspecialchars($row['name']) . "):</h4>";
        if ($row['scoring_layout_config']) {
            $config = json_decode($row['scoring_layout_config'], true);
            echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 4px;'>";
            echo json_encode($config, JSON_PRETTY_PRINT);
            echo "</pre>";
        } else {
            echo "<p style='color: #dc3545;'>No configuration found</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 15px; border-radius: 5px; color: #721c24;'>";
    echo "<h3>❌ Error:</h3>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

<style>
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 20px;
    line-height: 1.6;
}
h1, h2, h3 {
    margin-top: 30px;
}
table {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
</style>