<?php
/**
 * Test Base URL Configuration
 * This file demonstrates that URLs are dynamically generated based on the server accessing the application
 */

require_once 'includes/config.php';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Base URL Configuration Test - StyleScore</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h3 class="mb-0"><i class="bi bi-link-45deg"></i> Base URL Configuration Test</h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h5>How It Works:</h5>
                            <p class="mb-0">The application now dynamically detects the server URL, so it works from:</p>
                            <ul class="mb-0 mt-2">
                                <li><strong>Localhost:</strong> http://localhost/v2/</li>
                                <li><strong>Local IP:</strong> http://192.168.x.x/v2/</li>
                                <li><strong>Domain:</strong> http://yourdomain.com/v2/</li>
                            </ul>
                        </div>

                        <h5 class="mt-4">Current Configuration:</h5>
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Setting</th>
                                    <th>Value</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>Protocol:</strong></td>
                                    <td><?php echo (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "HTTPS" : "HTTP"; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Host/Domain:</strong></td>
                                    <td><code><?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>Server IP:</strong></td>
                                    <td><code><?php echo htmlspecialchars($_SERVER['SERVER_ADDR'] ?? 'N/A'); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>Client IP:</strong></td>
                                    <td><code><?php echo htmlspecialchars($_SERVER['REMOTE_ADDR']); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>Script Path:</strong></td>
                                    <td><code><?php echo htmlspecialchars($_SERVER['SCRIPT_NAME']); ?></code></td>
                                </tr>
                            </tbody>
                        </table>

                        <h5 class="mt-4">Generated URLs:</h5>
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>URL Type</th>
                                    <th>Generated URL</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>BASE_URL</strong></td>
                                    <td><code><?php echo htmlspecialchars(BASE_URL); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>API_URL</strong></td>
                                    <td><code><?php echo htmlspecialchars(API_URL); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>ASSETS_URL</strong></td>
                                    <td><code><?php echo htmlspecialchars(ASSETS_URL); ?></code></td>
                                </tr>
                                <tr>
                                    <td><strong>PHOTOS_URL</strong></td>
                                    <td><code><?php echo htmlspecialchars(PHOTOS_URL); ?></code></td>
                                </tr>
                            </tbody>
                        </table>

                        <h5 class="mt-4">Test Links:</h5>
                        <div class="list-group">
                            <a href="<?php echo BASE_URL; ?>dashboard.php" class="list-group-item list-group-item-action">
                                <strong>Dashboard</strong><br>
                                <small class="text-muted"><?php echo BASE_URL; ?>dashboard.php</small>
                            </a>
                            <a href="<?php echo BASE_URL; ?>public_event_dashboard.php" class="list-group-item list-group-item-action">
                                <strong>Public Event Dashboard</strong><br>
                                <small class="text-muted"><?php echo BASE_URL; ?>public_event_dashboard.php</small>
                            </a>
                            <a href="<?php echo BASE_URL; ?>admin/events.php" class="list-group-item list-group-item-action">
                                <strong>Admin: Events</strong><br>
                                <small class="text-muted"><?php echo BASE_URL; ?>admin/events.php</small>
                            </a>
                        </div>

                        <div class="alert alert-success mt-4">
                            <h6>✓ Configuration Working!</h6>
                            <p class="mb-0">You're accessing this page from: <strong><?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?></strong></p>
                            <p class="mb-0 mt-1">All URLs will automatically use this host for navigation.</p>
                        </div>

                        <h5 class="mt-4">Network Access:</h5>
                        <div class="alert alert-warning">
                            <p><strong>To access from other devices on your network:</strong></p>
                            <ol class="mb-0">
                                <li>Find your computer's local IP address (e.g., 192.168.1.100)</li>
                                <li>On another device, browse to: <code>http://YOUR_IP/v2/</code></li>
                                <li>All links and API calls will automatically use that IP</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
