<?php
include '../includes/auth.php';
include '../includes/db.php';

// Test parameters - CHANGE THESE TO MATCH YOUR ACTUAL DATA
$event_id = $_GET['event_id'] ?? 6;  // Changed to 6 based on your data
$heat_number = $_GET['heat_number'] ?? 4;  // Changed to 4 based on your data
$run_number = $_GET['run_number'] ?? 1;
$judge_id = $_GET['judge_id'] ?? ($_SESSION['user_id'] ?? 35);  // Allow override, default to 35

echo "<h2>Testing Participant Lock Status</h2>";
echo "<p><strong>Judge ID: $judge_id</strong> (from session or URL parameter)</p>";
echo "<p>Event: $event_id, Heat: $heat_number, Run: $run_number</p>";
echo "<p><a href='?event_id=$event_id&heat_number=$heat_number&run_number=$run_number&judge_id=35'>Test with Judge 35</a> | ";
echo "<a href='?event_id=$event_id&heat_number=$heat_number&run_number=$run_number&judge_id=1'>Test with Judge 1</a></p>";

echo "<h3>1. All Participants in Heat $heat_number:</h3>";
$stmt = $pdo->prepare("SELECT ep.id as ep_id, p.first_name, p.last_name, ep.bib_number as bib
                       FROM event_participants ep
                       JOIN participants p ON ep.participant_id = p.id
                       WHERE ep.event_id = ? AND ep.heat_number = ?
                       ORDER BY ep.bib_number ASC");
$stmt->execute([$event_id, $heat_number]);
$participants = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($participants);
echo "</pre>";

echo "<h3>2. ALL Runs for this Heat:</h3>";
$runs_stmt = $pdo->prepare("
    SELECT 
        r.id as run_id,
        r.run_number,
        r.event_participant_id,
        ep.bib_number,
        p.first_name,
        p.last_name
    FROM runs r
    JOIN event_participants ep ON r.event_participant_id = ep.id
    JOIN participants p ON ep.participant_id = p.id
    WHERE ep.event_id = ? AND ep.heat_number = ? AND r.run_number = ?
    ORDER BY ep.bib_number ASC
");
$runs_stmt->execute([$event_id, $heat_number, $run_number]);
$runs = $runs_stmt->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($runs);
echo "</pre>";

echo "<h3>3. Scores by Judge $judge_id for Run $run_number:</h3>";
$scored_stmt = $pdo->prepare("
    SELECT 
        s.id as score_id,
        s.judge_id,
        s.score_value,
        s.status,
        s.is_approved,
        r.id as run_id,
        r.run_number,
        r.event_participant_id,
        ep.bib_number,
        p.first_name,
        p.last_name
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    JOIN event_participants ep ON r.event_participant_id = ep.id
    JOIN participants p ON ep.participant_id = p.id
    WHERE s.judge_id = ? AND r.run_number = ? AND ep.event_id = ? AND ep.heat_number = ?
    ORDER BY s.id DESC
");
$scored_stmt->execute([$judge_id, $run_number, $event_id, $heat_number]);
$scores = $scored_stmt->fetchAll(PDO::FETCH_ASSOC);
echo "<pre>";
print_r($scores);
echo "</pre>";

echo "<h3>4. Event Participant IDs that are LOCKED (using actual query from get_participants.php):</h3>";
$scored_ep_stmt = $pdo->prepare("
    SELECT DISTINCT r.event_participant_id
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    JOIN event_participants ep ON r.event_participant_id = ep.id
    WHERE s.judge_id = ? 
      AND r.run_number = ? 
      AND ep.event_id = ? 
      AND ep.heat_number = ?
");
$scored_ep_stmt->execute([$judge_id, $run_number, $event_id, $heat_number]);
$scored_ep_ids = $scored_ep_stmt->fetchAll(PDO::FETCH_COLUMN);
echo "<p><strong>Locked EP IDs:</strong></p>";
echo "<pre>";
print_r($scored_ep_ids);
echo "</pre>";

echo "<h3>5. Final Participant List with Lock Status:</h3>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>EP ID</th><th>BIB</th><th>Name</th><th>Locked?</th></tr>";
foreach ($participants as $p) {
    $locked = in_array($p['ep_id'], $scored_ep_ids) ? 'YES 🔒' : 'NO ✅';
    $style = in_array($p['ep_id'], $scored_ep_ids) ? 'background: #ffcccc;' : '';
    echo "<tr style='$style'>";
    echo "<td>{$p['ep_id']}</td>";
    echo "<td>{$p['bib']}</td>";
    echo "<td>{$p['first_name']} {$p['last_name']}</td>";
    echo "<td><strong>$locked</strong></td>";
    echo "</tr>";
}
echo "</table>";
?>
