<?php
// Migration script to add participant media fields
include '../includes/db.php';

try {
    // Add photo field
    $pdo->exec("ALTER TABLE participants ADD COLUMN photo VARCHAR(255) NULL COMMENT 'Path to participant photo file'");
    echo "Added photo field\n";
    
    // Add motion video field  
    $pdo->exec("ALTER TABLE participants ADD COLUMN motion_video VARCHAR(255) NULL COMMENT 'Path to participant motion/video file'");
    echo "Added motion_video field\n";
    
    // Create participant_facts table
    $pdo->exec("
        CREATE TABLE participant_facts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            participant_id INT NOT NULL,
            title VARCHAR(255) NOT NULL,
            fact TEXT NOT NULL,
            sort_order INT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (participant_id) REFERENCES participants(id) ON DELETE CASCADE,
            INDEX idx_participant_sort (participant_id, sort_order)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
    ");
    echo "Created participant_facts table\n";
    
    // Add indexes
    $pdo->exec("ALTER TABLE participants ADD INDEX idx_photo (photo)");
    $pdo->exec("ALTER TABLE participants ADD INDEX idx_motion_video (motion_video)");
    echo "Added indexes\n";
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
        echo "Column already exists, skipping...\n";
    } elseif (strpos($e->getMessage(), 'Table') !== false && strpos($e->getMessage(), 'already exists') !== false) {
        echo "Table already exists, skipping...\n";
    } else {
        echo "Migration error: " . $e->getMessage() . "\n";
    }
}
?>
