<?php
if (!function_exists('get_bib_series_for_event')) {
    function get_bib_series_for_event(PDO $pdo, int $event_id): array {
        $stmt = $pdo->prepare("SELECT * FROM bib_series WHERE event_id = ? ORDER BY id ASC");
        $stmt->execute([$event_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

if (!function_exists('get_event_participants_for_bib_distribution')) {
    function get_event_participants_for_bib_distribution(PDO $pdo, int $event_id): array {
        $stmt = $pdo->prepare("
            SELECT p.id, p.first_name, p.last_name, p.club, p.gender, p.date_of_birth,
                   ep.bib_number, 
                   GROUP_CONCAT(DISTINCT ep.heat_number ORDER BY ep.heat_number) as heat_numbers,
                   GROUP_CONCAT(DISTINCT ep.category ORDER BY ep.category) as categories,
                   MIN(ep.id) as event_participant_id
            FROM participants p
            INNER JOIN event_participants ep ON ep.participant_id = p.id
            WHERE ep.event_id = ?
            GROUP BY p.id, p.first_name, p.last_name, p.club, p.gender, p.date_of_birth, ep.bib_number
            ORDER BY p.last_name ASC, p.first_name ASC
        ");
        $stmt->execute([$event_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
