<?php
echo "Testing database connection...\n";

try {
    include 'includes/db.php';
    echo "Database connected successfully\n";
    
    // Check participant_facts table
    $result = $pdo->query("SHOW TABLES LIKE 'participant_facts'");
    if ($result->rowCount() > 0) {
        echo "participant_facts table exists\n";
    } else {
        echo "participant_facts table does NOT exist - creating it...\n";
        
        // Create the table
        $pdo->exec("
            CREATE TABLE participant_facts (
                id INT AUTO_INCREMENT PRIMARY KEY,
                participant_id INT NOT NULL,
                title VARCHAR(255) NOT NULL,
                fact TEXT NOT NULL,
                sort_order INT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (participant_id) REFERENCES participants(id) ON DELETE CASCADE,
                INDEX idx_participant_sort (participant_id, sort_order)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
        ");
        echo "participant_facts table created\n";
    }
    
    // Check photo column
    $result = $pdo->query("SHOW COLUMNS FROM participants LIKE 'photo'");
    if ($result->rowCount() > 0) {
        echo "photo column exists\n";
    } else {
        echo "photo column does NOT exist - adding it...\n";
        $pdo->exec("ALTER TABLE participants ADD COLUMN photo VARCHAR(255) NULL");
        echo "photo column added\n";
    }
    
    echo "All database checks completed successfully\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
