<?php
require 'includes/db.php';

// Get all configs with heat_number set for event 3
$stmt = $pdo->query("SELECT id, name, heat_number, configuration FROM result_configurations WHERE event_id = 3 AND heat_number IS NOT NULL");
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Found " . count($configs) . " heat-specific configurations\n\n";

foreach ($configs as $config) {
    $settings = json_decode($config['configuration'], true);
    $current_direction = $settings['heatDirection'] ?? 'NOT SET';
    
    echo "Config {$config['id']}: {$config['name']}\n";
    echo "  Heat: {$config['heat_number']}\n";
    echo "  Current heatDirection: {$current_direction}\n";
    
    if ($current_direction !== 'column') {
        $settings['heatDirection'] = 'column';
        $new_config = json_encode($settings);
        
        $update = $pdo->prepare("UPDATE result_configurations SET configuration = ? WHERE id = ?");
        $update->execute([$new_config, $config['id']]);
        
        echo "  ✓ Updated to 'column'\n";
    } else {
        echo "  Already set to 'column'\n";
    }
    echo "\n";
}

echo "Done!\n";
