<?php
require_once 'includes/db.php';

echo "=== CONFIGURATIONS FOR EVENT 6 ===\n\n";
$stmt = $pdo->query("SELECT id, name, view_type, event_id, heat_number, category, configuration FROM result_configurations WHERE event_id = 6 AND view_type = 'summary_table'");
while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "ID: " . $row['id'] . "\n";
    echo "Name: " . $row['name'] . "\n";
    echo "Heat Number: " . $row['heat_number'] . "\n";
    echo "Category: " . $row['category'] . "\n";
    echo "Configuration: " . substr($row['configuration'], 0, 200) . "...\n";
    echo "---\n\n";
}

echo "\n=== PARTICIPANTS IN EVENT 6 ===\n\n";
$stmt = $pdo->query("SELECT p.id, p.bib_number, p.first_name, p.last_name, ep.category_id, ep.heat_number 
                     FROM participants p 
                     JOIN event_participants ep ON p.id = ep.participant_id 
                     WHERE ep.event_id = 6 
                     ORDER BY ep.heat_number, p.bib_number");
$participants = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "Total participants: " . count($participants) . "\n";
foreach($participants as $p) {
    echo "BIB {$p['bib_number']}: {$p['first_name']} {$p['last_name']} | Heat: {$p['heat_number']} | Category: {$p['category_id']}\n";
}

echo "\n=== SCORES IN EVENT 6 ===\n\n";
$stmt = $pdo->query("SELECT s.participant_id, p.bib_number, p.first_name, p.last_name, s.run_number, s.heat_number, s.total_score 
                     FROM scoring_results s
                     JOIN participants p ON s.participant_id = p.id
                     WHERE s.event_id = 6
                     ORDER BY s.heat_number, s.participant_id, s.run_number");
$scores = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "Total scores: " . count($scores) . "\n";
foreach($scores as $sc) {
    echo "BIB {$sc['bib_number']}: {$sc['first_name']} {$sc['last_name']} | Heat: {$sc['heat_number']} | Run: {$sc['run_number']} | Score: {$sc['total_score']}\n";
}

echo "\n=== CATEGORIES IN EVENT 6 ===\n\n";
$stmt = $pdo->query("SELECT DISTINCT c.id, c.name FROM categories c
                     JOIN event_participants ep ON c.id = ep.category_id
                     WHERE ep.event_id = 6");
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach($categories as $cat) {
    echo "Category ID {$cat['id']}: {$cat['name']}\n";
}
