<?php
require_once 'includes/db.php';

$config_id = 74;

// Get the configuration
$stmt = $pdo->prepare("SELECT * FROM result_configurations WHERE id = ?");
$stmt->execute([$config_id]);
$config = $stmt->fetch(PDO::FETCH_ASSOC);

echo "=== DATABASE CONFIG ===\n";
echo "ID: " . $config['id'] . "\n";
echo "Configuration JSON: " . $config['configuration'] . "\n\n";

$config_settings = json_decode($config['configuration'], true);
echo "=== PARSED SETTINGS ===\n";
print_r($config_settings);

echo "\n=== HEAT DIRECTION CHECK ===\n";
echo "heatDirection in config: " . (isset($config_settings['heatDirection']) ? $config_settings['heatDirection'] : 'NOT SET') . "\n";

// Now simulate what the API does
$heat_direction = $_GET['heat_direction'] ?? 'row';
echo "\nheat_direction from URL parameter: " . $heat_direction . "\n";

$heat_direction = $config_settings['heatDirection'] ?? $heat_direction;
echo "Final heat_direction (after config override): " . $heat_direction . "\n";

echo "\n";
if ($heat_direction === 'column') {
    echo "✅ COLUMN MODE ACTIVE - Should generate stacked layout\n";
} else {
    echo "❌ ROW MODE ACTIVE - Will generate side-by-side layout\n";
}
